/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data.packets;

import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.weido.create_bb.data.compat.steamnrails.RailwaysSelectionOverride;
import com.weido.create_bb.data.menu.Entry.StyleMenuHandler;
import com.weido.create_bb.registry.BogiePackets;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BogieStylePacket
implements CustomPacketPayload {
    private final BasePacketPayload.PacketTypeProvider typeProvider;

    protected BogieStylePacket(BasePacketPayload.PacketTypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public static class Serverbound
    extends BogieStylePacket
    implements ServerboundPacketPayload {
        final BogeyStyle style;
        @Nullable
        final BogeySizes.BogeySize size;
        @Nullable
        final BlockPos pos;
        public static final StreamCodec<FriendlyByteBuf, Serverbound> STREAM_CODEC = StreamCodec.ofMember((packet, buf) -> {
            buf.writeResourceLocation(packet.style.id);
            buf.writeBoolean(packet.size != null);
            if (packet.size != null) {
                buf.writeResourceLocation(packet.size.id());
            }
            buf.writeBoolean(packet.pos != null);
            if (packet.pos != null) {
                buf.writeBlockPos(packet.pos);
            }
        }, buf -> {
            ResourceLocation loc = buf.readResourceLocation();
            BogeyStyle style = AllBogeyStyles.BOGEY_STYLES.getOrDefault(loc, AllBogeyStyles.STANDARD);
            BogeySizes.BogeySize size = null;
            if (buf.readBoolean()) {
                ResourceLocation sizeLoc = buf.readResourceLocation();
                size = (BogeySizes.BogeySize)BogeySizes.all().get(sizeLoc);
            }
            BlockPos pos = null;
            if (buf.readBoolean()) {
                pos = buf.readBlockPos();
            }
            return new Serverbound(style, size, pos);
        });

        public Serverbound(@NotNull BogeyStyle style, @Nullable BogeySizes.BogeySize size, @Nullable BlockPos pos) {
            super(BogiePackets.C_BOGIE_STYLE);
            this.style = style;
            this.size = size;
            this.pos = pos;
        }

        public void handle(ServerPlayer player) {
            Level level = player.level();
            if (this.pos != null && level.getBlockEntity(this.pos) instanceof AbstractBogeyBlockEntity) {
                AbstractBogeyBlock newBlock = this.style.getBlockForSize(this.size);
                BlockState newState = (BlockState)newBlock.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)((Direction.Axis)level.getBlockState(this.pos).getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)));
                level.setBlock(this.pos, newState, 3);
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (blockEntity instanceof AbstractBogeyBlockEntity) {
                    AbstractBogeyBlockEntity newBe = (AbstractBogeyBlockEntity)blockEntity;
                    newBe.setBogeyStyle(this.style);
                }
            }
            if (this.size != null) {
                if (ModList.get().isLoaded("railways")) {
                    RailwaysSelectionOverride.addStyle(player.getUUID(), Pair.of((Object)this.style, (Object)this.size));
                } else {
                    StyleMenuHandler.addStyle(player.getUUID(), (Pair<BogeyStyle, BogeySizes.BogeySize>)Pair.of((Object)this.style, (Object)this.size));
                }
            }
        }
    }
}

