/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.config;

import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.network.CCPackets;
import com.copycatsplus.copycats.network.ConfigSyncPacket;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.config.ModConfig;

public abstract class SyncConfigBase
extends ConfigBase {
    public final CompoundTag getSyncConfig() {
        CompoundTag nbt = new CompoundTag();
        this.writeSyncConfig(nbt);
        if (this.children != null) {
            for (ConfigBase child : this.children) {
                if (!(child instanceof SyncConfigBase)) continue;
                SyncConfigBase syncChild = (SyncConfigBase)child;
                if (nbt.contains(child.getName())) {
                    throw new RuntimeException("A sync config key starts with " + child.getName() + " but does not belong to the child");
                }
                nbt.put(child.getName(), (Tag)syncChild.getSyncConfig());
            }
        }
        return nbt;
    }

    protected abstract ModConfig.Type type();

    protected void writeSyncConfig(CompoundTag nbt) {
    }

    public final void setSyncConfig(CompoundTag config) {
        if (this.children != null) {
            for (ConfigBase child : this.children) {
                if (!(child instanceof SyncConfigBase)) continue;
                SyncConfigBase syncChild = (SyncConfigBase)child;
                CompoundTag nbt = config.getCompound(child.getName());
                syncChild.readSyncConfig(nbt);
            }
        }
        this.readSyncConfig(config);
    }

    protected void readSyncConfig(CompoundTag nbt) {
    }

    public void onLoad() {
        super.onLoad();
    }

    public void onReload() {
        super.onReload();
    }

    public void syncToPlayer(ServerPlayer player) {
        if (player == null) {
            return;
        }
        CCPackets.network().sendToClient(player, (CustomPacketPayload)new ConfigSyncPacket(this.getSyncConfig(), this.type()));
        Copycats.LOGGER.debug("Sync Config: Sending server config to {}", (Object)player.getName().getString());
    }
}

