/*
 * Decompiled with CFR 0.152.
 */
package net.jaiz.coolrain.mixin;

import javax.annotation.Nullable;
import net.jaiz.coolrain.CoolRainSounds;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LevelRenderer.class})
public class RainMixin {
    @Shadow
    @Nullable
    private ClientLevel level;
    @Mutable
    @Final
    @Shadow
    private final Minecraft minecraft;
    @Shadow
    private int ticks;
    @Shadow
    private int rainSoundTime;

    public RainMixin(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    @Inject(method={"tickRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void tickRain(Camera camera, CallbackInfo ci) {
        if (this.level.effects().tickRain(this.level, this.ticks, camera)) {
            return;
        }
        float f = this.minecraft.level.getRainLevel(1.0f) / (Minecraft.useFancyGraphics() ? 1.0f : 2.0f);
        if (!(f <= 0.0f)) {
            RandomSource randomsource = RandomSource.create((long)((long)this.ticks * 312987231L));
            ClientLevel levelreader = this.minecraft.level;
            BlockPos blockpos = BlockPos.containing((Position)camera.getPosition());
            BlockPos blockpos1 = null;
            int i = (int)(100.0f * f * f) / (this.minecraft.options.particles().get() == ParticleStatus.DECREASED ? 2 : 1);
            for (int j = 0; j < i; ++j) {
                Biome biome;
                int l;
                int k = randomsource.nextInt(21) - 10;
                BlockPos blockpos2 = levelreader.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos.offset(k, 0, l = randomsource.nextInt(21) - 10));
                if (blockpos2.getY() <= levelreader.getMinBuildHeight() || blockpos2.getY() > blockpos.getY() + 10 || blockpos2.getY() < blockpos.getY() - 10 || (biome = (Biome)levelreader.getBiome(blockpos2).value()).getPrecipitationAt(blockpos2) != Biome.Precipitation.RAIN) continue;
                blockpos1 = blockpos2.below();
                if (this.minecraft.options.particles().get() == ParticleStatus.MINIMAL) break;
                double d0 = randomsource.nextDouble();
                double d1 = randomsource.nextDouble();
                BlockState blockstate = levelreader.getBlockState(blockpos1);
                FluidState fluidstate = levelreader.getFluidState(blockpos1);
                VoxelShape voxelshape = blockstate.getCollisionShape((BlockGetter)levelreader, blockpos1);
                double d2 = voxelshape.max(Direction.Axis.Y, d0, d1);
                double d3 = fluidstate.getHeight((BlockGetter)levelreader, blockpos1);
                double d4 = Math.max(d2, d3);
                SimpleParticleType particleoptions = !fluidstate.is(FluidTags.LAVA) && !blockstate.is(Blocks.MAGMA_BLOCK) && !CampfireBlock.isLitCampfire((BlockState)blockstate) ? ParticleTypes.RAIN : ParticleTypes.SMOKE;
                this.minecraft.level.addParticle((ParticleOptions)particleoptions, (double)blockpos1.getX() + d0, (double)blockpos1.getY() + d4, (double)blockpos1.getZ() + d1, 0.0, 0.0, 0.0);
            }
            if (blockpos1 != null && randomsource.nextInt(3) < this.rainSoundTime++) {
                this.rainSoundTime = 0;
                if (blockpos1.getY() > blockpos.getY() + 1 && levelreader.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos).getY() > Mth.floor((float)blockpos.getY())) {
                    this.minecraft.level.playLocalSound(blockpos1, SoundEvents.WEATHER_RAIN_ABOVE, SoundSource.WEATHER, 0.1f, 0.5f, false);
                }
                if (this.minecraft.level.getBlockState(blockpos1).is(Blocks.COPPER_BLOCK) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WEATHERED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.EXPOSED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.OXIDIZED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_COPPER_BLOCK) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_WEATHERED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_EXPOSED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_OXIDIZED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.COPPER_BULB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WEATHERED_COPPER_BULB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.EXPOSED_COPPER_BULB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.OXIDIZED_COPPER_BULB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_COPPER_BULB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_WEATHERED_COPPER_BULB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_EXPOSED_COPPER_BULB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_OXIDIZED_COPPER_BULB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.COPPER_GRATE) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WEATHERED_COPPER_GRATE) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.EXPOSED_COPPER_GRATE) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.OXIDIZED_COPPER_GRATE) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_COPPER_GRATE) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_WEATHERED_COPPER_GRATE) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_EXPOSED_COPPER_GRATE) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_OXIDIZED_COPPER_GRATE) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.CHISELED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WEATHERED_CHISELED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.EXPOSED_CHISELED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.OXIDIZED_CHISELED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_CHISELED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_WEATHERED_CHISELED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_EXPOSED_CHISELED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_OXIDIZED_CHISELED_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.CUT_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WEATHERED_CUT_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.EXPOSED_CUT_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.OXIDIZED_CUT_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_CUT_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_WEATHERED_CUT_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_EXPOSED_CUT_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_OXIDIZED_CUT_COPPER) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WEATHERED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.EXPOSED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.OXIDIZED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_WEATHERED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_EXPOSED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.CUT_COPPER_SLAB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WEATHERED_CUT_COPPER_SLAB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.EXPOSED_CUT_COPPER_SLAB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.OXIDIZED_CUT_COPPER_SLAB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_CUT_COPPER_SLAB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_WEATHERED_CUT_COPPER_SLAB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_EXPOSED_CUT_COPPER_SLAB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_OXIDIZED_CUT_COPPER_SLAB) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WEATHERED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.EXPOSED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.OXIDIZED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_WEATHERED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_EXPOSED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.NETHERITE_BLOCK) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.IRON_BLOCK) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.RAW_IRON_BLOCK) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.RAW_COPPER_BLOCK) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.RAW_GOLD_BLOCK) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.GOLD_BLOCK)) {
                    this.minecraft.level.playLocalSound(blockpos1, CoolRainSounds.RAIN_SOUNDS_METAL.get(), SoundSource.WEATHER, 0.5f, 1.0f, true);
                } else if (this.minecraft.level.getBlockState(blockpos1).is(BlockTags.WOOL)) {
                    this.minecraft.level.playLocalSound(blockpos1, CoolRainSounds.RAIN_SOUNDS_FABRIC.get(), SoundSource.WEATHER, 0.5f, 1.0f, true);
                } else if (this.minecraft.level.getBlockState(blockpos1).is(Blocks.GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.TINTED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.LIGHT_GRAY_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.GREEN_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.BROWN_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.BLUE_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.RED_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.PINK_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.MAGENTA_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.YELLOW_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.GRAY_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.BLACK_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.WHITE_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.LIME_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.PURPLE_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.LIGHT_BLUE_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.ORANGE_STAINED_GLASS) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.CYAN_STAINED_GLASS)) {
                    this.minecraft.level.playLocalSound(blockpos1, CoolRainSounds.RAIN_SOUNDS_GLASS.get(), SoundSource.WEATHER, 0.2f, 1.0f, true);
                } else if (this.minecraft.level.getBlockState(blockpos1).is(BlockTags.LEAVES)) {
                    this.minecraft.level.playLocalSound(blockpos1, CoolRainSounds.RAIN_SOUNDS_FOLIAGE.get(), SoundSource.WEATHER, 0.2f, 1.0f, true);
                } else if (this.minecraft.level.getBlockState(blockpos1).is(Blocks.WATER)) {
                    this.minecraft.level.playLocalSound(blockpos1, CoolRainSounds.RAIN_SOUNDS_WATER.get(), SoundSource.WEATHER, 0.175f, 1.0f, true);
                } else if (this.minecraft.level.getBlockState(blockpos1).is(Blocks.LAVA) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.MAGMA_BLOCK) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.CAMPFIRE) || this.minecraft.level.getBlockState(blockpos1).is(Blocks.SOUL_CAMPFIRE)) {
                    this.minecraft.level.playLocalSound(blockpos1, CoolRainSounds.RAIN_SOUNDS_LAVA.get(), SoundSource.WEATHER, 0.2f, 1.0f, true);
                    this.minecraft.level.playLocalSound(blockpos1, SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.1f, (float)this.minecraft.level.getRandom().nextIntBetweenInclusive(8, 12) * 0.1f, false);
                } else {
                    this.minecraft.level.playLocalSound(blockpos1, SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.2f, 1.0f, false);
                }
            }
            ci.cancel();
        }
    }
}

