/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.item.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiBaseColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternTypeVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiSecondaryPatternColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiSecondaryPatternTypeVariant;
import net.emilsg.clutterbestiary.util.ModUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class KoiBucketItem
extends MobBucketItem {
    public static final MapCodec<KoiBaseColorVariant> BASE_COLOR_CODEC = KoiBaseColorVariant.CODEC.fieldOf("BaseColor");
    public static final MapCodec<KoiPrimaryPatternTypeVariant> PRIMARY_TYPE_CODEC = KoiPrimaryPatternTypeVariant.CODEC.fieldOf("PrimaryPatternType");
    public static final MapCodec<KoiPrimaryPatternColorVariant> PRIMARY_COLOR_CODEC = KoiPrimaryPatternColorVariant.CODEC.fieldOf("PrimaryPatternColor");
    public static final MapCodec<KoiSecondaryPatternTypeVariant> SECONDARY_TYPE_CODEC = KoiSecondaryPatternTypeVariant.CODEC.fieldOf("SecondaryPatternType");
    public static final MapCodec<KoiSecondaryPatternColorVariant> SECONDARY_COLOR_CODEC = KoiSecondaryPatternColorVariant.CODEC.fieldOf("SecondaryPatternColor");
    private final Supplier<? extends EntityType<?>> type;

    public KoiBucketItem(Supplier<? extends EntityType<?>> type, Fluid fluid, SoundEvent emptyingSound, Item.Properties settings) {
        super(null, fluid, emptyingSound, settings);
        this.type = type;
    }

    public void checkExtraContent(@Nullable Player player, Level world, ItemStack stack, BlockPos pos) {
        if (world instanceof ServerLevel) {
            this.spawnEntity((ServerLevel)world, stack, pos);
            world.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, ctx, tooltip, type);
        CustomData cmp = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
        Optional baseOpt = cmp.read(BASE_COLOR_CODEC).result();
        if (baseOpt.isEmpty()) {
            return;
        }
        KoiBaseColorVariant base = (KoiBaseColorVariant)baseOpt.get();
        tooltip.add((Component)Component.translatable((String)"tooltip.clutterbestiary.base_color.koi").withStyle(ChatFormatting.GRAY));
        if (base.hasSeparateTexture()) {
            int tick = (int)(System.currentTimeMillis() / 100L) % base.getColorHex().length;
            tooltip.add(ModUtil.buildCyclicFormattedName("tooltip.clutterbestiary." + base.getName() + ".koi", base.getColorHex(), tick, true));
            return;
        }
        tooltip.add((Component)Component.translatable((String)("tooltip.clutterbestiary." + base.getName() + ".koi")).withStyle(base.getFormatting()));
        KoiPrimaryPatternTypeVariant pType = cmp.read(PRIMARY_TYPE_CODEC).result().orElse(null);
        KoiPrimaryPatternColorVariant pColor = cmp.read(PRIMARY_COLOR_CODEC).result().orElse(null);
        KoiSecondaryPatternTypeVariant sType = cmp.read(SECONDARY_TYPE_CODEC).result().orElse(null);
        KoiSecondaryPatternColorVariant sColor = cmp.read(SECONDARY_COLOR_CODEC).result().orElse(null);
        if (pType != null && pColor != null) {
            tooltip.add((Component)Component.translatable((String)"tooltip.clutterbestiary.primary_pattern.koi").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)("tooltip.clutterbestiary." + pType.getName() + ".koi")).withStyle(pType.getFormatting()).withStyle(pColor.getFormatting()));
        }
        if (sType != null && sColor != null) {
            tooltip.add((Component)Component.translatable((String)"tooltip.clutterbestiary.secondary_pattern.koi").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)("tooltip.clutterbestiary." + sType.getName() + ".koi")).withStyle(sType.getFormatting()).withStyle(sColor.getFormatting()));
        }
        tooltip.add(CommonComponents.EMPTY);
    }

    private void spawnEntity(ServerLevel world, ItemStack stack, BlockPos pos) {
        Entity entity = this.type.get().spawn(world, stack, null, pos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            CustomData nbtComponent = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
            bucketable.loadFromBucketTag(nbtComponent.copyTag());
            bucketable.setFromBucket(true);
        }
    }
}

