/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.item.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.ButterflyEntity;
import net.emilsg.clutterbestiary.entity.variants.ButterflyVariant;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class ButterflyBottleItem
extends Item {
    public static final MapCodec<ButterflyVariant> BUTTERFLY_VARIANT_MAP_CODEC = ButterflyVariant.CODEC.fieldOf("Variant");

    public ButterflyBottleItem(Item.Properties settings) {
        super(settings);
    }

    public static ItemStack getEmptiedStack(ItemStack stack, Player player) {
        return !player.getAbilities().instabuild ? new ItemStack((ItemLike)Items.GLASS_BOTTLE) : stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        CustomData nbtComponent = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
        Optional optional = nbtComponent.read(BUTTERFLY_VARIANT_MAP_CODEC).result();
        if (optional.isPresent()) {
            ButterflyVariant variant = (ButterflyVariant)((Object)optional.get());
            ChatFormatting formatting = variant.getColorFormatting();
            String string = "clutterbestiary." + variant.getName() + ".butterfly";
            MutableComponent mutableText = Component.translatable((String)string);
            mutableText.withStyle(formatting);
            tooltip.add((Component)mutableText);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (world instanceof ServerLevel) {
            this.spawnEntity((ServerLevel)world, stack, pos);
            world.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
            world.playSound(null, pos, SoundEvents.WOOL_PLACE, SoundSource.NEUTRAL);
            player.setItemInHand(hand, ButterflyBottleItem.getEmptiedStack(stack, player));
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    private void spawnEntity(ServerLevel world, ItemStack stack, BlockPos pos) {
        ButterflyEntity butterfly = (ButterflyEntity)((EntityType)ModEntityTypes.BUTTERFLY.get()).spawn(world, stack, null, pos, MobSpawnType.BUCKET, true, false);
        CustomData nbtComponent = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (butterfly != null) {
            butterfly.copyDataFromNbt(butterfly, nbtComponent.copyTag());
        }
    }
}

