/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.variants.koi;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.emilsg.clutterbestiary.entity.variants.BestiaryBasicVariant;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;

public enum KoiSecondaryPatternColorVariant implements BestiaryBasicVariant
{
    BLACK("black", ChatFormatting.DARK_GRAY, 1843750),
    WHITE("white", ChatFormatting.WHITE, 12829669);

    private static final Map<ResourceLocation, KoiSecondaryPatternColorVariant> BY_ID;
    public static final Codec<KoiSecondaryPatternColorVariant> CODEC;
    private final String name;
    private final ChatFormatting colorFormatting;
    private final int colorHex;

    private KoiSecondaryPatternColorVariant(String name, ChatFormatting colorFormatting, int colorHex) {
        this.name = name;
        this.colorFormatting = colorFormatting;
        this.colorHex = colorHex;
    }

    public static KoiSecondaryPatternColorVariant fromId(String id) {
        return Arrays.stream(KoiSecondaryPatternColorVariant.values()).filter(v -> v.getID().equals(id)).findFirst().orElse(BLACK);
    }

    public static KoiSecondaryPatternColorVariant getRandom() {
        List<KoiSecondaryPatternColorVariant> variants = Arrays.stream(KoiSecondaryPatternColorVariant.values()).toList();
        return variants.get(new Random().nextInt(variants.size()));
    }

    @Override
    public String getID() {
        return "clutterbestiary:" + this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChatFormatting getFormatting() {
        return this.colorFormatting;
    }

    public int getColorHex() {
        return this.colorHex;
    }

    static {
        BY_ID = Arrays.stream(KoiSecondaryPatternColorVariant.values()).collect(Collectors.toMap(v -> ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)v.getName()), v -> v));
        CODEC = ResourceLocation.CODEC.comapFlatMap(id -> {
            KoiSecondaryPatternColorVariant v = BY_ID.get(id);
            return v != null ? DataResult.success((Object)v) : DataResult.error(() -> "Unknown koi secondary pattern color variant: " + String.valueOf(id));
        }, v -> ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)v.getName()));
    }
}

