/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.variants.koi;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.emilsg.clutterbestiary.entity.variants.BestiaryBasicVariant;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;

public enum KoiPrimaryPatternTypeVariant implements BestiaryBasicVariant
{
    NONE("none", ChatFormatting.STRIKETHROUGH),
    PATCHES("patches", ChatFormatting.ITALIC),
    SPOTTED("spotted", ChatFormatting.ITALIC),
    STRIPED("striped", ChatFormatting.ITALIC);

    private static final Map<ResourceLocation, KoiPrimaryPatternTypeVariant> BY_ID;
    public static final Codec<KoiPrimaryPatternTypeVariant> CODEC;
    private final String name;
    private final ChatFormatting formatting;

    private KoiPrimaryPatternTypeVariant(String name, ChatFormatting formatting) {
        this.name = name;
        this.formatting = formatting;
    }

    public static KoiPrimaryPatternTypeVariant fromId(String id) {
        return Arrays.stream(KoiPrimaryPatternTypeVariant.values()).filter(v -> v.getID().equals(id)).findFirst().orElse(NONE);
    }

    public static KoiPrimaryPatternTypeVariant getRandom() {
        List<KoiPrimaryPatternTypeVariant> variants = Arrays.stream(KoiPrimaryPatternTypeVariant.values()).toList();
        return variants.get(new Random().nextInt(variants.size()));
    }

    @Override
    public String getID() {
        return "clutterbestiary:" + this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChatFormatting getFormatting() {
        return this.formatting;
    }

    public ResourceLocation getTextureLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)("textures/entity/koi/koi_primary_pattern_" + this.getName() + ".png"));
    }

    static {
        BY_ID = Arrays.stream(KoiPrimaryPatternTypeVariant.values()).collect(Collectors.toMap(v -> ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)v.getName()), v -> v));
        CODEC = ResourceLocation.CODEC.comapFlatMap(id -> {
            KoiPrimaryPatternTypeVariant v = BY_ID.get(id);
            return v != null ? DataResult.success((Object)v) : DataResult.error(() -> "Unknown koi primary pattern type variant: " + String.valueOf(id));
        }, v -> ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)v.getName()));
    }
}

