/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.variants;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;

public enum EchofinVariant {
    CHORUS("chorus"),
    LEVITATING("levitating");

    private final String name;

    private EchofinVariant(String name) {
        this.name = name;
    }

    public static EchofinVariant fromId(String id) {
        return Arrays.stream(EchofinVariant.values()).filter(v -> v.getId().equals(id)).findFirst().orElse(CHORUS);
    }

    public static EchofinVariant getRandom() {
        List<EchofinVariant> variants = Arrays.stream(EchofinVariant.values()).toList();
        return variants.get(new Random().nextInt(variants.size()));
    }

    public ResourceLocation getEmissiveTextureLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)("textures/entity/echofin/" + this.getName() + "_echofin_emissive.png"));
    }

    public String getId() {
        return "clutterbestiary:" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getTextureLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)("textures/entity/echofin/" + this.getName() + "_echofin.png"));
    }
}

