/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WanderAroundFarOftenGoal
extends Goal {
    private final PathfinderMob pathAwareEntity;
    private final float speed;

    public WanderAroundFarOftenGoal(PathfinderMob pathAwareEntity, float speed) {
        this.pathAwareEntity = pathAwareEntity;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.pathAwareEntity.getNavigation().isDone() && this.pathAwareEntity.getRandom().nextInt(4) == 0 && !this.pathAwareEntity.isVehicle();
    }

    public boolean canContinueToUse() {
        return !this.pathAwareEntity.getNavigation().isDone() && !this.pathAwareEntity.isVehicle() && this.pathAwareEntity.getNavigation().isInProgress();
    }

    public void start() {
        Vec3 wanderTarget = this.getWanderTarget();
        if (wanderTarget == null) {
            return;
        }
        this.pathAwareEntity.getNavigation().moveTo(wanderTarget.x(), wanderTarget.y(), wanderTarget.z(), (double)this.speed);
    }

    public void stop() {
        this.pathAwareEntity.getNavigation().stop();
        super.stop();
    }

    @Nullable
    protected Vec3 getWanderTarget() {
        if (this.pathAwareEntity.isInWaterOrBubble()) {
            Vec3 preferredPath = LandRandomPos.getPos((PathfinderMob)this.pathAwareEntity, (int)15, (int)6);
            return preferredPath == null ? DefaultRandomPos.getPos((PathfinderMob)this.pathAwareEntity, (int)10, (int)6) : preferredPath;
        }
        return LandRandomPos.getPos((PathfinderMob)this.pathAwareEntity, (int)10, (int)6);
    }
}

