/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import net.emilsg.clutterbestiary.entity.custom.MossbloomEntity;
import net.emilsg.clutterbestiary.item.ModItems;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MossbloomDropHornsGoal
extends Goal {
    private final MossbloomEntity mossbloom;
    private final ItemStack antlerStack = new ItemStack((ItemLike)ModItems.MOSSBLOOM_ANTLERS.get());
    private boolean hasDroppedAntlers = false;

    public MossbloomDropHornsGoal(MossbloomEntity mossbloom) {
        this.mossbloom = mossbloom;
        this.antlerStack.setCount(2);
    }

    public boolean canUse() {
        return this.mossbloom.getHasHorns() && this.mossbloom.getHornDropTimer() > MossbloomEntity.SHOULD_DROP_HORNS_VALUE;
    }

    public boolean canContinueToUse() {
        return this.mossbloom.getHasHorns() && this.mossbloom.getHornDropTimer() > MossbloomEntity.SHOULD_DROP_HORNS_VALUE && !this.hasDroppedAntlers;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void start() {
        this.mossbloom.setIsShaking(true);
        this.mossbloom.getNavigation().stop();
    }

    public void stop() {
        this.hasDroppedAntlers = false;
        this.mossbloom.setTimeTillDrop(0);
    }

    public void tick() {
        this.mossbloom.setTimeTillDrop(this.mossbloom.getTimeTillDrop() + 1);
        if (this.mossbloom.getTimeTillDrop() >= 60) {
            this.mossbloom.setHornDropTimer(0);
            this.mossbloom.setHasHorns(false);
            this.mossbloom.spawnAtLocation(this.antlerStack);
            this.hasDroppedAntlers = true;
            this.mossbloom.setIsShaking(false);
            this.mossbloom.shakingAnimationState.stop();
        }
    }
}

