/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import java.util.EnumSet;
import net.emilsg.clutterbestiary.entity.custom.DragonflyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class DragonflyFastWanderGoal
extends Goal {
    private final DragonflyEntity dragonflyEntity;

    public DragonflyFastWanderGoal(DragonflyEntity dragonflyEntity) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.dragonflyEntity = dragonflyEntity;
    }

    public static int rayCastDown(Level world, BlockPos start, int maxDepth) {
        for (int i = 1; i <= maxDepth; ++i) {
            BlockPos checkPos = start.below(i);
            if (world.getBlockState(checkPos).isAir()) continue;
            return i;
        }
        return maxDepth;
    }

    public boolean canUse() {
        return this.dragonflyEntity.getNavigation().isDone() && this.dragonflyEntity.getRandom().nextInt(8) == 0;
    }

    public boolean canContinueToUse() {
        return this.dragonflyEntity.getNavigation().isInProgress();
    }

    public void start() {
        Vec3 vec3d = this.getRandomLocation();
        if (vec3d != null) {
            BlockPos pos = BlockPos.containing((double)vec3d.x, (double)vec3d.y, (double)vec3d.z);
            double speed = this.dragonflyEntity.getAttributeValue(Attributes.FLYING_SPEED);
            Path path = this.dragonflyEntity.getNavigation().createPath(pos, 1);
            if (path != null) {
                this.dragonflyEntity.getNavigation().moveTo(path, speed);
            }
        }
        super.start();
    }

    public void tick() {
        if (this.dragonflyEntity.isInWater()) {
            this.stop();
        }
    }

    private Vec3 getRandomLocation() {
        int blocksToGround = DragonflyFastWanderGoal.rayCastDown(this.dragonflyEntity.level(), this.dragonflyEntity.blockPosition(), 16);
        Vec3 dragonflyRotation = this.dragonflyEntity.getViewVector(0.0f);
        Vec3 targetedPos = HoverRandomPos.getPos((PathfinderMob)this.dragonflyEntity, (int)8, (int)4, (double)dragonflyRotation.x, (double)dragonflyRotation.z, (float)1.5707964f, (int)4, (int)2);
        if (targetedPos != null) {
            if (blocksToGround > 5) {
                targetedPos = new Vec3(targetedPos.x, targetedPos.y - (double)blocksToGround * 0.5, targetedPos.z);
            }
            return targetedPos;
        }
        return AirAndWaterRandomPos.getPos((PathfinderMob)this.dragonflyEntity, (int)8, (int)4, (int)-2, (double)dragonflyRotation.x, (double)dragonflyRotation.z, (double)1.5707963705062866);
    }
}

