/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.AbstractNetherNewtEntity;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentTameableEntity;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class WarpedNewtEntity
extends AbstractNetherNewtEntity {
    public WarpedNewtEntity(EntityType<? extends ParentTameableEntity> entityType, Level world) {
        super(entityType, world);
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.WARPED_NEWTS_SPAWN_ON);
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)((EntityType)ModEntityTypes.WARPED_NEWT.get()).create((Level)world);
    }

    @Override
    protected Item getTamingItem() {
        return Items.TWISTING_VINES;
    }

    @Override
    public Item getBreedingItem() {
        return Items.WARPED_ROOTS;
    }

    @Override
    public Holder<MobEffect> getOnAttackEffect() {
        return MobEffects.POISON;
    }

    @Override
    protected Item getFungusItem() {
        return Items.WARPED_FUNGUS;
    }
}

