/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.UUID;
import java.util.function.Predicate;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.goal.SeahorseFollowParentGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.SeahorseMateGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.SeahorseMoveToCoralGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.SeahorseReleaseChildrenGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.SwimToRandomPlaceGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentFishEntity;
import net.emilsg.clutterbestiary.entity.variants.SeahorseVariant;
import net.emilsg.clutterbestiary.item.ModItems;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class SeahorseEntity
extends ParentFishEntity
implements Bucketable {
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(SeahorseEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> HAS_CHILDREN = SynchedEntityData.defineId(SeahorseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> HAS_CHILDREN_TIMER = SynchedEntityData.defineId(SeahorseEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> CHILD = SynchedEntityData.defineId(SeahorseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState swimmingAnimationState = new AnimationState();
    public final AnimationState flopAnimationState = new AnimationState();
    protected int breedingAge;
    protected int forcedAge;
    protected int happyTicksRemaining;
    private int ticker = 0;
    private int loveTicks;
    @Nullable
    private UUID lovingPlayer;
    private int swimmingAnimationTimeout = 0;
    private int flopAnimationTimeout = 0;

    public SeahorseEntity(EntityType<? extends AbstractFish> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return SeahorseEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 2.0);
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends WaterAnimal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos).is(ModBlockTags.SEAHORSES_SPAWN_ON);
    }

    public static int toGrowUpAge(int breedingAge) {
        return (int)((float)(breedingAge / 20) * 0.1f);
    }

    public void breed(ServerLevel world, SeahorseEntity other) {
        this.breed(world, other, null);
    }

    public void breed(ServerLevel world, SeahorseEntity other, @Nullable SeahorseEntity baby) {
        this.setBreedingAge(6000);
        other.setBreedingAge(6000);
        this.setHasChildren(true);
        this.resetLoveTicks();
        other.resetLoveTicks();
        world.broadcastEntityEvent((Entity)this, (byte)18);
        if (world.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            world.addFreshEntity((Entity)new ExperienceOrb((Level)world, this.getX(), this.getY(), this.getZ(), this.getRandom().nextInt(7) + 1));
        }
    }

    public boolean canBreedWith(SeahorseEntity other) {
        if (other == this) {
            return false;
        }
        if (((Object)((Object)other)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.isInLove() && other.isInLove();
    }

    public boolean canEat() {
        return this.loveTicks <= 0;
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    public void loadFromBucketTag(CompoundTag nbt) {
        if (nbt.contains("Variant")) {
            this.setVariant(SeahorseVariant.fromId(nbt.getString("Variant")));
        }
        super.loadFromBucketTag(nbt);
    }

    public void saveToBucketTag(ItemStack stack) {
        super.saveToBucketTag(stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, nbtCompound -> nbtCompound.putString("Variant", this.getTypeVariant()));
    }

    @Nullable
    public SeahorseEntity createChild(ServerLevel world, SeahorseEntity entity) {
        return (SeahorseEntity)((EntityType)ModEntityTypes.SEAHORSE.get()).create((Level)world);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.loveTicks = 0;
        return super.hurt(source, amount);
    }

    public int getBreedingAge() {
        if (this.level().isClientSide) {
            return (Boolean)this.entityData.get(CHILD) != false ? -1 : 1;
        }
        return this.breedingAge;
    }

    public void setBreedingAge(int age) {
        int i = this.getBreedingAge();
        this.breedingAge = age;
        if (i < 0 && age >= 0 || i >= 0 && age < 0) {
            this.entityData.set(CHILD, (Object)(age < 0 ? 1 : 0));
            this.onGrowUp();
        }
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ModItems.SEAHORSE_BUCKET.get());
    }

    public float getHasChildrenTimer() {
        return ((Float)this.entityData.get(HAS_CHILDREN_TIMER)).floatValue();
    }

    public void setHasChildrenTimer(float hasChildrenTimer) {
        this.entityData.set(HAS_CHILDREN_TIMER, (Object)Float.valueOf(hasChildrenTimer));
    }

    public int getLoveTicks() {
        return this.loveTicks;
    }

    public void setLoveTicks(int loveTicks) {
        this.loveTicks = loveTicks;
    }

    @Nullable
    public ServerPlayer getLovingPlayer() {
        if (this.lovingPlayer == null) {
            return null;
        }
        Player playerEntity = this.level().getPlayerByUUID(this.lovingPlayer);
        return playerEntity instanceof ServerPlayer ? (ServerPlayer)playerEntity : null;
    }

    public int getMaxChildren() {
        return 3;
    }

    public SeahorseVariant getVariant() {
        return SeahorseVariant.fromId(this.getTypeVariant());
    }

    public void setVariant(SeahorseVariant variant) {
        this.entityData.set(VARIANT, (Object)variant.getId());
    }

    public void growUp(int age, boolean overGrow) {
        int i;
        int j = i = this.getBreedingAge();
        if ((i += age * 20) > 0) {
            i = 0;
        }
        int k = i - j;
        this.setBreedingAge(i);
        if (overGrow) {
            this.forcedAge += k;
            if (this.happyTicksRemaining == 0) {
                this.happyTicksRemaining = 40;
            }
        }
        if (this.getBreedingAge() == 0) {
            this.setBreedingAge(this.forcedAge);
        }
    }

    public void growUp(int age) {
        this.growUp(age, false);
    }

    public void handleEntityEvent(byte status) {
        if (status == 18) {
            for (int i = 0; i < 7; ++i) {
                double d = this.random.nextGaussian() * 0.02;
                double e = this.random.nextGaussian() * 0.02;
                double f = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d, e, f);
            }
        } else {
            super.handleEntityEvent(status);
        }
    }

    public boolean hasChildren() {
        return (Boolean)this.entityData.get(HAS_CHILDREN);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        AgeableMob.AgeableMobGroupData passiveData;
        if (entityData == null) {
            entityData = new AgeableMob.AgeableMobGroupData(true);
        }
        if ((passiveData = (AgeableMob.AgeableMobGroupData)entityData).isShouldSpawnBaby() && passiveData.getGroupSize() > 0 && world.getRandom().nextFloat() <= passiveData.getBabySpawnChance()) {
            this.setBreedingAge(-24000);
        }
        passiveData.increaseGroupSizeByOne();
        SeahorseVariant variant = SeahorseVariant.getRandom();
        this.setVariant(variant);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.isBreedingItem(itemStack)) {
            int i = this.getBreedingAge();
            if (!this.level().isClientSide && i == 0 && this.canEat()) {
                this.eat(player, hand, itemStack);
                this.lovePlayer(player);
                return InteractionResult.SUCCESS;
            }
            if (this.isBaby()) {
                this.eat(player, hand, itemStack);
                this.growUp(SeahorseEntity.toGrowUpAge(-i), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
        }
        return super.mobInteract(player, hand);
    }

    public boolean isBaby() {
        return this.getBreedingAge() < 0;
    }

    public void setBaby(boolean baby) {
        this.setBreedingAge(baby ? -24000 : 0);
    }

    public boolean isBreedingItem(ItemStack stack) {
        return stack.is(Items.SEA_PICKLE);
    }

    public boolean isInLove() {
        return this.getLoveTicks() > 0;
    }

    public boolean isReadyToBreed() {
        return false;
    }

    public void lovePlayer(@Nullable Player player) {
        this.loveTicks = 600;
        if (player != null) {
            this.lovingPlayer = player.getUUID();
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)18);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (CHILD.equals(data)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(data);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(VARIANT, (Object)nbt.getString("Variant"));
        this.entityData.set(HAS_CHILDREN, (Object)nbt.getBoolean("HasChildren"));
        this.entityData.set(HAS_CHILDREN_TIMER, (Object)Float.valueOf(nbt.getFloat("HasChildrenTimer")));
        this.loveTicks = nbt.getInt("InLove");
        this.lovingPlayer = nbt.hasUUID("LoveCause") ? nbt.getUUID("LoveCause") : null;
        this.setBreedingAge(nbt.getInt("Age"));
        this.forcedAge = nbt.getInt("ForcedAge");
    }

    public void resetLoveTicks() {
        this.setLoveTicks(0);
    }

    public void setHasChildren(boolean hasChildren) {
        this.entityData.set(HAS_CHILDREN, (Object)hasChildren);
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (!world.isClientSide) {
            ++this.ticker;
            if (this.hasChildren() && this.ticker == 120) {
                this.setHasChildrenTimer(this.getHasChildrenTimer() + 0.2f);
                this.ticker = 0;
            }
        }
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void aiStep() {
        if (!this.isInWater() && this.onGround() && this.verticalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.setOnGround(false);
            this.hasImpulse = true;
            this.playSound(this.getFlopSound(), this.getSoundVolume(), this.getVoicePitch());
        }
        if (this.getBreedingAge() != 0) {
            this.loveTicks = 0;
        }
        if (this.loveTicks > 0) {
            --this.loveTicks;
            if (this.loveTicks % 10 == 0) {
                double d = this.random.nextGaussian() * 0.02;
                double e = this.random.nextGaussian() * 0.02;
                double f = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d, e, f);
            }
        }
        if (this.level().isClientSide) {
            if (this.happyTicksRemaining > 0) {
                if (this.happyTicksRemaining % 4 == 0) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
                --this.happyTicksRemaining;
            }
        } else if (this.isAlive()) {
            int i = this.getBreedingAge();
            if (i < 0) {
                this.setBreedingAge(++i);
            } else if (i > 0) {
                this.setBreedingAge(--i);
            }
        }
        super.aiStep();
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("Variant", this.getTypeVariant());
        nbt.putBoolean("HasChildren", this.hasChildren());
        nbt.putFloat("HasChildrenTimer", this.getHasChildrenTimer());
        nbt.putInt("InLove", this.loveTicks);
        if (this.lovingPlayer != null) {
            nbt.putUUID("LoveCause", this.lovingPlayer);
        }
        nbt.putInt("Age", this.getBreedingAge());
        nbt.putInt("ForcedAge", this.forcedAge);
    }

    protected void eat(Player player, InteractionHand hand, ItemStack stack) {
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.TROPICAL_FISH_FLOP;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)SeahorseVariant.YELLOW.getId());
        builder.define(HAS_CHILDREN, (Object)false);
        builder.define(HAS_CHILDREN_TIMER, (Object)Float.valueOf(0.0f));
        builder.define(CHILD, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(1, (Goal)new SeahorseFollowParentGoal(this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new SeahorseMateGoal(this, 1.0, SeahorseEntity.class));
        this.goalSelector.addGoal(3, (Goal)new SeahorseReleaseChildrenGoal(this));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.SEA_PICKLE}), false));
        this.goalSelector.addGoal(5, (Goal)new SwimToRandomPlaceGoal(this, 0.5));
        this.goalSelector.addGoal(6, (Goal)new SeahorseMoveToCoralGoal(this, 0.5, 8));
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.SALMON_DEATH;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SALMON_HURT;
    }

    protected void customServerAiStep() {
        if (this.getBreedingAge() != 0) {
            this.loveTicks = 0;
        }
        super.customServerAiStep();
    }

    protected void onGrowUp() {
        Boat boatEntity;
        Entity var2;
        if (!this.isBaby() && this.isPassenger() && (var2 = this.getVehicle()) instanceof Boat && !(boatEntity = (Boat)var2).hasEnoughSpaceFor((Entity)this)) {
            this.stopRiding();
        }
    }

    private String getTypeVariant() {
        return (String)this.entityData.get(VARIANT);
    }

    private void setupAnimationStates() {
        if (this.swimmingAnimationTimeout <= 0) {
            this.swimmingAnimationTimeout = 20;
            this.swimmingAnimationState.start(this.tickCount);
        } else {
            --this.swimmingAnimationTimeout;
        }
        if (this.flopAnimationTimeout <= 0) {
            this.flopAnimationTimeout = 20;
            this.flopAnimationState.start(this.tickCount);
        } else {
            --this.flopAnimationTimeout;
        }
    }
}

