/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.List;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.KoiEntity;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiBaseColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternTypeVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiSecondaryPatternColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiSecondaryPatternTypeVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class KoiEggsEntity
extends Mob {
    private static final EntityDataAccessor<String> BASE_COLOR = SynchedEntityData.defineId(KoiEggsEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> PRIMARY_PATTERN_COLOR = SynchedEntityData.defineId(KoiEggsEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> PRIMARY_PATTERN_TYPE = SynchedEntityData.defineId(KoiEggsEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> SECONDARY_PATTERN_COLOR = SynchedEntityData.defineId(KoiEggsEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> SECONDARY_PATTERN_TYPE = SynchedEntityData.defineId(KoiEggsEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private int timeToHatch = 120;

    public KoiEggsEntity(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 1.0);
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
    }

    public Iterable<ItemStack> getArmorSlots() {
        return List.of();
    }

    public KoiBaseColorVariant getBaseColorVariant() {
        return KoiBaseColorVariant.fromId((String)this.entityData.get(BASE_COLOR));
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SALMON_HURT;
    }

    public void setBaseColorVariant(KoiBaseColorVariant baseColorVariant) {
        this.entityData.set(BASE_COLOR, (Object)baseColorVariant.getID());
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return ItemStack.EMPTY;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public KoiPrimaryPatternColorVariant getPrimaryPatternColorVariant() {
        return KoiPrimaryPatternColorVariant.fromId((String)this.entityData.get(PRIMARY_PATTERN_COLOR));
    }

    public void setPrimaryPatternColorVariant(KoiPrimaryPatternColorVariant primaryPatternColorVariant) {
        this.entityData.set(PRIMARY_PATTERN_COLOR, (Object)primaryPatternColorVariant.getID());
    }

    public KoiPrimaryPatternTypeVariant getPrimaryPatternTypeVariant() {
        return KoiPrimaryPatternTypeVariant.fromId((String)this.entityData.get(PRIMARY_PATTERN_TYPE));
    }

    public void setPrimaryPatternTypeVariant(KoiPrimaryPatternTypeVariant primaryPatternTypeVariant) {
        this.entityData.set(PRIMARY_PATTERN_TYPE, (Object)primaryPatternTypeVariant.getID());
    }

    public KoiSecondaryPatternColorVariant getSecondaryPatternColorVariant() {
        return KoiSecondaryPatternColorVariant.fromId((String)this.entityData.get(SECONDARY_PATTERN_COLOR));
    }

    public void setSecondaryPatternColorVariant(KoiSecondaryPatternColorVariant secondaryPatternColorVariant) {
        this.entityData.set(SECONDARY_PATTERN_COLOR, (Object)secondaryPatternColorVariant.getID());
    }

    public KoiSecondaryPatternTypeVariant getSecondaryPatternTypeVariant() {
        return KoiSecondaryPatternTypeVariant.fromId((String)this.entityData.get(SECONDARY_PATTERN_TYPE));
    }

    public void setSecondaryPatternTypeVariant(KoiSecondaryPatternTypeVariant secondaryPatternTypeVariant) {
        this.entityData.set(SECONDARY_PATTERN_TYPE, (Object)secondaryPatternTypeVariant.getID());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setBaseColorVariant(KoiBaseColorVariant.fromId(nbt.getString("BaseColor")));
        this.setPrimaryPatternColorVariant(KoiPrimaryPatternColorVariant.fromId(nbt.getString("PrimaryPatternColor")));
        this.setPrimaryPatternTypeVariant(KoiPrimaryPatternTypeVariant.fromId(nbt.getString("PrimaryPatternType")));
        this.setSecondaryPatternColorVariant(KoiSecondaryPatternColorVariant.fromId(nbt.getString("SecondaryPatternColor")));
        this.setSecondaryPatternTypeVariant(KoiSecondaryPatternTypeVariant.fromId(nbt.getString("SecondaryPatternType")));
    }

    public void tick() {
        this.setNoGravity(this.isUnderWater());
        this.tickHatching(this.level());
        super.tick();
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("BaseColor", this.getBaseColorVariant().getID());
        nbt.putString("PrimaryPatternColor", this.getPrimaryPatternColorVariant().getID());
        nbt.putString("PrimaryPatternType", this.getPrimaryPatternTypeVariant().getID());
        nbt.putString("SecondaryPatternColor", this.getSecondaryPatternColorVariant().getID());
        nbt.putString("SecondaryPatternType", this.getSecondaryPatternTypeVariant().getID());
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.SLIME_DEATH_SMALL;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BASE_COLOR, (Object)KoiBaseColorVariant.ORANGE.getID());
        builder.define(PRIMARY_PATTERN_COLOR, (Object)KoiPrimaryPatternColorVariant.WHITE.getID());
        builder.define(PRIMARY_PATTERN_TYPE, (Object)KoiPrimaryPatternTypeVariant.SPOTTED.getID());
        builder.define(SECONDARY_PATTERN_COLOR, (Object)KoiSecondaryPatternColorVariant.BLACK.getID());
        builder.define(SECONDARY_PATTERN_TYPE, (Object)KoiSecondaryPatternTypeVariant.SMALL_SPOTS.getID());
    }

    private void hatch(Level world) {
        int i;
        int amount = this.random.nextInt(13) == 0 ? (this.random.nextBoolean() ? 3 : 2) : 1;
        double x = this.getX() + (double)(amount > 1 ? (float)(this.random.nextBoolean() ? 1 : -1) * this.random.nextFloat() / 5.0f : 0.0f);
        double y = this.getY() + (double)(amount > 1 ? (float)(this.random.nextBoolean() ? 1 : -1) * this.random.nextFloat() / 5.0f : 0.0f);
        double z = this.getZ() + (double)(amount > 1 ? (float)(this.random.nextBoolean() ? 1 : -1) * this.random.nextFloat() / 5.0f : 0.0f);
        for (i = 0; i < amount; ++i) {
            if (!world.isClientSide) continue;
            world.addParticle((ParticleOptions)ParticleTypes.BUBBLE, x, y, z, 0.0, 5.0E-4, 0.0);
        }
        for (i = 0; i < amount; ++i) {
            if (!(world instanceof ServerLevel)) continue;
            ServerLevel serverWorld = (ServerLevel)world;
            KoiEntity koiEntity = (KoiEntity)((EntityType)ModEntityTypes.KOI.get()).create((Level)serverWorld);
            if (koiEntity == null) {
                return;
            }
            koiEntity.setBaby(true);
            koiEntity.setBaseColorVariant(this.getBaseColorVariant());
            koiEntity.setPrimaryPatternColorVariant(this.getPrimaryPatternColorVariant());
            koiEntity.setPrimaryPatternTypeVariant(this.getPrimaryPatternTypeVariant());
            koiEntity.setSecondaryPatternColorVariant(this.getSecondaryPatternColorVariant());
            koiEntity.setSecondaryPatternTypeVariant(this.getSecondaryPatternTypeVariant());
            koiEntity.moveTo(x, y, z, this.getYRot(), this.getXRot());
            serverWorld.addFreshEntity((Entity)koiEntity);
        }
        this.kill();
        this.discard();
    }

    public void aiStep() {
        super.aiStep();
        this.floatAboveGroundInWater();
    }

    private void tickHatching(Level world) {
        if (this.timeToHatch <= 0) {
            this.hatch(world);
        }
        --this.timeToHatch;
        if (world.isClientSide && this.timeToHatch % 1200 == 0 && this.timeToHatch != 0) {
            world.broadcastEntityEvent((Entity)this, (byte)7);
            world.playSound(null, this.blockPosition(), SoundEvents.SNIFFER_EGG_CRACK, SoundSource.NEUTRAL, 0.5f, 1.5f);
        }
    }

    private void floatAboveGroundInWater() {
        if (!this.isInWater()) {
            return;
        }
        BlockPos currentPos = this.blockPosition();
        Level world = this.level();
        for (int y = 0; y < 10; ++y) {
            BlockPos checkPos = currentPos.below(y);
            if (world.getBlockState(checkPos).isAir() || !world.getBlockState(checkPos).isRedstoneConductor((BlockGetter)world, checkPos)) continue;
            double targetY = (double)checkPos.getY() + 2.0;
            double verticalVelocity = this.getY() < targetY ? 0.01 : 0.0;
            double pushX = 0.0;
            double pushZ = 0.0;
            if (world.getBlockState(currentPos.north()).isRedstoneConductor((BlockGetter)world, currentPos.north())) {
                pushZ += 0.001;
            }
            if (world.getBlockState(currentPos.south()).isRedstoneConductor((BlockGetter)world, currentPos.south())) {
                pushZ -= 0.001;
            }
            if (world.getBlockState(currentPos.east()).isRedstoneConductor((BlockGetter)world, currentPos.east())) {
                pushX -= 0.001;
            }
            if (world.getBlockState(currentPos.west()).isRedstoneConductor((BlockGetter)world, currentPos.west())) {
                pushX += 0.001;
            }
            this.setDeltaMovement(this.getDeltaMovement().x + pushX, verticalVelocity, this.getDeltaMovement().z + pushZ);
            break;
        }
    }
}

