/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.function.Predicate;
import net.emilsg.clutterbestiary.block.ModBlocks;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.goal.EmperorPenguinLayEggGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmperorPenguinMateGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.sound.ModSoundEvents;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class EmperorPenguinEntity
extends ParentAnimalEntity {
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.of((TagKey)ItemTags.FISHES);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.defineId(EmperorPenguinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> EGG_TIMER = SynchedEntityData.defineId(EmperorPenguinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState flapAnimationStateOne = new AnimationState();
    public final AnimationState flapAnimationStateTwo = new AnimationState();
    public final AnimationState preenAnimationState = new AnimationState();
    public int randomAnimationTimeout = 0;

    public EmperorPenguinEntity(EntityType<? extends ParentAnimalEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ParentAnimalEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, (double)0.14f).add(Attributes.ATTACK_SPEED, 0.5).add(Attributes.ATTACK_KNOCKBACK, (double)0.1f).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public boolean canFallInLove() {
        return super.canFallInLove() && !this.hasEgg();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)((EntityType)ModEntityTypes.EMPEROR_PENGUIN.get()).create((Level)world);
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.EMPEROR_PENGUINS_SPAWN_ON);
    }

    public int getAmbientSoundInterval() {
        return 240;
    }

    public void playAmbientSound() {
        SoundEvent soundEvent = this.getAmbientSound();
        if (soundEvent != null) {
            this.playSound(soundEvent, this.getSoundVolume(), this.getVoicePitch() + 0.3f);
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return ModSoundEvents.ENTITY_EMPEROR_PENGUIN_AMBIENT.get();
    }

    public int getEggTimer() {
        return (Integer)this.entityData.get(EGG_TIMER);
    }

    public void setEggTimer(int time) {
        this.entityData.set(EGG_TIMER, (Object)time);
    }

    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.FISHES);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setHasEgg(nbt.getBoolean("HasEgg"));
        this.setEggTimer(nbt.getInt("EggTimer"));
    }

    public void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.hasEgg()) {
            this.setEggTimer(this.getEggTimer() + 1);
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("HasEgg", this.hasEgg());
        nbt.putInt("EggTimer", this.getEggTimer());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_EGG, (Object)false);
        builder.define(EGG_TIMER, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new EmperorPenguinMateGoal(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new EmperorPenguinLayEggGoal(this, 1.0, ((Block)ModBlocks.EMPEROR_PENGUIN_EGG.get()).defaultBlockState()));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)BREEDING_INGREDIENT, false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void updateWalkAnimation(float v) {
        float f = this.getPose() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f * 1.5f, 0.3f);
    }

    private void pickRandomIdleAnim(int i) {
        switch (i) {
            case 1: {
                this.flapAnimationStateTwo.startIfStopped(this.tickCount);
                break;
            }
            case 2: {
                this.preenAnimationState.startIfStopped(this.tickCount);
                break;
            }
            default: {
                this.flapAnimationStateOne.startIfStopped(this.tickCount);
            }
        }
    }

    private void setupAnimationStates() {
        if (this.randomAnimationTimeout <= 0 && this.random.nextInt(400) == 0 && this.getNavigation().isDone()) {
            this.randomAnimationTimeout = 400;
            this.pickRandomIdleAnim(this.random.nextInt(3));
        } else {
            --this.randomAnimationTimeout;
        }
    }
}

