/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseFollowParentGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseLookAroundGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseLookAtEntityGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseMateGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseMeleeGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseTemptGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseWanderAroundFarGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.sound.ModSoundEvents;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.emilsg.clutterbestiary.util.ModUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EmberTortoiseEntity
extends ParentAnimalEntity {
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.defineId(EmberTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(EmberTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SHIELDING = SynchedEntityData.defineId(EmberTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> SHIELDING_DURATION = SynchedEntityData.defineId(EmberTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SHIELDING_COOLDOWN = SynchedEntityData.defineId(EmberTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.FIRE_CHARGE});
    public static Map<Block, Block> smeltableBlocksConversionMap = new HashMap<Block, Block>();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState shieldingAnimationState = new AnimationState();
    public final AnimationState shieldingTubeAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public int idleAnimationTimeout = 0;
    public int shieldingAnimationTimeout = 0;
    public int attackAnimationTimeout = 0;
    private int fireSoundTicker = 0;
    private int fireChargeSoundTicker = 0;

    public EmberTortoiseEntity(EntityType<? extends ParentAnimalEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ParentAnimalEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.MOVEMENT_SPEED, (double)0.175f).add(Attributes.ATTACK_DAMAGE, 8.0);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        if (stackInHand.is(this.getShieldingRechargeItem())) {
            if (this.canShield()) {
                this.startShielding();
                player.playSound(SoundEvents.FIRECHARGE_USE, 0.5f + this.random.nextFloat(), 0.75f);
                player.swing(hand);
                if (!player.getAbilities().instabuild) {
                    stackInHand.shrink(1);
                }
            } else {
                int cooldown = this.getShieldingCooldown();
                this.setShieldingCooldown(cooldown - 100);
            }
        }
        return super.mobInteract(player, hand);
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.EMBER_TORTOISES_SPAWN_ON);
    }

    public boolean canShield() {
        return this.getShieldingCooldown() <= 0;
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)((EntityType)ModEntityTypes.EMBER_TORTOISE.get()).create((Level)world);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isShielding()) {
            LivingEntity livingEntity = (LivingEntity)source.getEntity();
            Entity entity = source.getDirectEntity();
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                projectile.setDeltaMovement(projectile.getDeltaMovement().scale(-1.0));
                return false;
            }
            if (livingEntity != null && livingEntity.getMainHandItem().getItem() instanceof PickaxeItem) {
                return super.hurt(source, amount * 2.0f);
            }
            return super.hurt(source, amount / 16.0f);
        }
        return super.hurt(source, amount);
    }

    public int getShieldingCooldown() {
        return (Integer)this.entityData.get(SHIELDING_COOLDOWN);
    }

    public void setShieldingCooldown(int shieldingCooldown) {
        this.entityData.set(SHIELDING_COOLDOWN, (Object)shieldingCooldown);
    }

    public int getShieldingDuration() {
        return (Integer)this.entityData.get(SHIELDING_DURATION);
    }

    public void setShieldingDuration(int shieldingDuration) {
        this.entityData.set(SHIELDING_DURATION, (Object)shieldingDuration);
    }

    public Item getShieldingRechargeItem() {
        return Items.BLAZE_POWDER;
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (this.isAlive() && this.getHealth() <= this.getMaxHealth() / 4.0f && this.canShield() && !world.isClientSide()) {
            this.startShielding();
        } else if (this.isAlive() && this.getShieldingDuration() <= 0 && !world.isClientSide()) {
            this.setShielding(false);
        }
        if (this.isShielding() && world.isClientSide && !this.isDeadOrDying()) {
            Vec3 entityPos = this.position();
            Random random = new Random();
            int numberOfParticles = 10;
            ++this.fireSoundTicker;
            ++this.fireChargeSoundTicker;
            if (this.fireSoundTicker >= 20) {
                world.playLocalSound(entityPos.x() + 0.5, entityPos.y() + 0.5, entityPos.z() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.NEUTRAL, 0.5f + random.nextFloat(), 0.0125f, false);
                this.fireSoundTicker = 0;
            }
            if (this.fireChargeSoundTicker >= 20) {
                world.playLocalSound(entityPos.x() + 0.5, entityPos.y() + 0.5, entityPos.z() + 0.5, SoundEvents.FIRECHARGE_USE, SoundSource.NEUTRAL, 0.5f + random.nextFloat(), 0.25f, false);
                this.fireChargeSoundTicker = 0;
            }
            for (int i = 0; i < numberOfParticles; ++i) {
                double velocityX = (random.nextDouble() - 0.5) * 0.4;
                double velocityY = (random.nextDouble() - 0.5) * 0.4;
                double velocityZ = (random.nextDouble() - 0.5) * 0.4;
                world.addParticle((ParticleOptions)(random.nextBoolean() ? ParticleTypes.FLAME : ParticleTypes.SMALL_FLAME), entityPos.x, entityPos.y + 1.0, entityPos.z, velocityX, velocityY, velocityZ);
            }
        }
        if (this.isShielding() && !world.isClientSide() && !this.isDeadOrDying()) {
            if (this.isInWaterOrRain()) {
                this.setShielding(false);
            }
            this.setShieldingDuration(this.getShieldingDuration() - 1);
            AABB area = new AABB(this.blockPosition()).inflate(3.0, 1.0, 3.0);
            List nearbyEntities = world.getEntitiesOfClass(LivingEntity.class, area, e -> true);
            if (nearbyEntities != null) {
                for (LivingEntity entity : nearbyEntities) {
                    entity.setSharedFlagOnFire(true);
                    entity.setRemainingFireTicks(100);
                    if (!(entity instanceof Player)) continue;
                    Player player = (Player)entity;
                    if (!(world instanceof ServerLevel)) continue;
                    ServerLevel serverWorld = (ServerLevel)world;
                    ModUtil.grantImpossibleAdvancement("bestiary/hot_hot_hot", serverWorld, player);
                }
            }
            this.meltNearbyBlocks(world);
        }
        if (!world.isClientSide() && this.getHealth() < this.getMaxHealth() && this.random.nextInt(200) == 0 && this.level().dimensionTypeRegistration().is(BuiltinDimensionTypes.NETHER) && this.isAlive()) {
            this.setHealth((int)(this.getHealth() + 1.0f));
        }
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
    }

    public boolean isAggressive() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    public void setAggressive(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.is(Items.FIRE_CHARGE);
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean isInvulnerable() {
        return this.isShielding();
    }

    @Override
    public boolean isMoving() {
        return (Boolean)this.entityData.get(MOVING);
    }

    @Override
    public void setMoving(boolean moving) {
        this.entityData.set(MOVING, (Object)moving);
    }

    public boolean isPushable() {
        return !this.isShielding();
    }

    public boolean isShielding() {
        return (Boolean)this.entityData.get(SHIELDING);
    }

    public void setShielding(boolean shielding) {
        this.entityData.set(SHIELDING, (Object)shielding);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setShielding(nbt.getBoolean("Shielding"));
        this.setShieldingDuration(nbt.getInt("ShieldingDuration"));
        this.setShieldingCooldown(nbt.getInt("ShieldingCooldown"));
    }

    public void knockback(double strength, double x, double z) {
        super.knockback(0.0, x, z);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSoundEvents.ENTITY_EMBER_TORTOISE_HURT.get();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            BlockPos newPos;
            BlockPos oldPos = this.blockPosition();
            this.setMoving(oldPos != (newPos = this.blockPosition()));
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("Shielding", this.isShielding());
        nbt.putInt("ShieldingDuration", this.getShieldingDuration());
        nbt.putInt("ShieldingCooldown", this.getShieldingCooldown());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOVING, (Object)false);
        builder.define(ATTACKING, (Object)false);
        builder.define(SHIELDING, (Object)false);
        builder.define(SHIELDING_COOLDOWN, (Object)0);
        builder.define(SHIELDING_DURATION, (Object)400);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new EmberTortoiseMeleeGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new EmberTortoiseMateGoal(this, 1.2f));
        this.goalSelector.addGoal(4, (Goal)new EmberTortoiseTemptGoal(this, 1.2f, BREEDING_INGREDIENT, false));
        this.goalSelector.addGoal(5, (Goal)new EmberTortoiseFollowParentGoal(this, 1.2f));
        this.goalSelector.addGoal(6, (Goal)new EmberTortoiseWanderAroundFarGoal(this, 1.0, 0.001f));
        this.goalSelector.addGoal(7, (Goal)new EmberTortoiseLookAtEntityGoal(this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new EmberTortoiseLookAroundGoal(this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Hoglin.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Zoglin.class, true));
    }

    protected void updateWalkAnimation(float v) {
        float f = this.getPose() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f * 3.0f, 0.3f);
    }

    private void meltNearbyBlocks(Level world) {
        BlockPos center = this.blockPosition();
        int radius = 3;
        BlockPos.betweenClosedStream((BlockPos)center.offset(-radius, -radius, -radius), (BlockPos)center.offset(radius + 1, radius, radius + 1)).filter(pos -> pos.closerThan((Vec3i)center, (double)radius + 0.5)).forEach(pos -> {
            BlockState state = world.getBlockState(pos);
            Block inputBlock = state.getBlock();
            ItemStack inputStack = new ItemStack((ItemLike)inputBlock.asItem());
            Optional match = world.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(inputStack), world);
            if (match.isPresent()) {
                ItemStack result = ((SmeltingRecipe)((RecipeHolder)match.get()).value()).getResultItem((HolderLookup.Provider)world.registryAccess());
                if (Block.byItem((Item)result.getItem()) != Blocks.AIR) {
                    Block resultBlock = Block.byItem((Item)result.getItem());
                    if (this.random.nextInt(750) == 0) {
                        world.setBlockAndUpdate(pos, resultBlock.defaultBlockState());
                    }
                }
            } else if (smeltableBlocksConversionMap.containsKey(inputBlock) && this.random.nextInt(750) == 0) {
                world.setBlockAndUpdate(pos, smeltableBlocksConversionMap.get(inputBlock).defaultBlockState());
            }
            if (this.random.nextInt(2000) == 0 && world.getBlockState(pos.above()).isAir() && state.isRedstoneConductor((BlockGetter)world, pos)) {
                world.setBlockAndUpdate(pos.above(), Blocks.FIRE.defaultBlockState());
            }
        });
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0 && !this.isMoving() && !this.isShielding()) {
            this.idleAnimationTimeout = 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAggressive() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 40;
            this.attackAnimationState.start(this.tickCount);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAggressive()) {
            this.attackAnimationState.stop();
        }
        if (this.isShielding() && this.shieldingAnimationTimeout <= 0) {
            this.shieldingAnimationState.start(this.tickCount);
            this.shieldingTubeAnimationState.startIfStopped(this.tickCount);
            this.shieldingAnimationTimeout = 1;
        } else if (!this.isShielding()) {
            this.shieldingAnimationTimeout = 0;
        }
    }

    private void startShielding() {
        this.setShielding(true);
        this.setShieldingDuration((this.random.nextIntBetweenInclusive(4, 8) + 1) * 100);
        this.setShieldingCooldown(2400);
    }

    static {
        smeltableBlocksConversionMap.put(Blocks.GRASS_BLOCK, Blocks.DIRT);
        smeltableBlocksConversionMap.put(Blocks.PODZOL, Blocks.DIRT);
        smeltableBlocksConversionMap.put(Blocks.MYCELIUM, Blocks.DIRT);
        smeltableBlocksConversionMap.put(Blocks.ICE, Blocks.WATER);
        smeltableBlocksConversionMap.put(Blocks.CRIMSON_NYLIUM, Blocks.NETHERRACK);
        smeltableBlocksConversionMap.put(Blocks.WARPED_NYLIUM, Blocks.NETHERRACK);
        smeltableBlocksConversionMap.put(Blocks.RAW_IRON_BLOCK, Blocks.IRON_BLOCK);
        smeltableBlocksConversionMap.put(Blocks.RAW_COPPER_BLOCK, Blocks.COPPER_BLOCK);
        smeltableBlocksConversionMap.put(Blocks.RAW_GOLD_BLOCK, Blocks.GOLD_BLOCK);
    }
}

