/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentTameableEntity;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class CapybaraEntity
extends ParentTameableEntity {
    private static final EntityDataAccessor<Boolean> IS_SLEEPING = SynchedEntityData.defineId(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FORCE_SLEEPING = SynchedEntityData.defineId(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> SLEEPER = SynchedEntityData.defineId(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON});
    public final AnimationState earTwitchAnimationStateOne = new AnimationState();
    public final AnimationState earTwitchAnimationStateTwo = new AnimationState();
    public final AnimationState sleepingAnimationState = new AnimationState();
    public int earTwitchAnimationTimeout = 0;
    public int sleepingAnimationTimeout = 0;

    public CapybaraEntity(EntityType<? extends ParentTameableEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.225f).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.ATTACK_KNOCKBACK, (double)0.1f).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public void healNearbyEntities(Entity centerEntity, double radius) {
        if (this.random.nextInt(1000) != 0) {
            return;
        }
        AABB area = new AABB(centerEntity.getX() - radius, centerEntity.getY() - radius, centerEntity.getZ() - radius, centerEntity.getX() + radius, centerEntity.getY() + radius, centerEntity.getZ() + radius);
        List nearbyEntities = centerEntity.level().getEntitiesOfClass(LivingEntity.class, area, e -> e != centerEntity);
        for (LivingEntity entity : nearbyEntities) {
            if (!(entity.getHealth() < entity.getMaxHealth())) continue;
            entity.heal(1.0f);
        }
    }

    public boolean canFallInLove() {
        return super.canFallInLove() && !this.isSleeping();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)((EntityType)ModEntityTypes.CAPYBARA.get()).create((Level)world);
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity = source.getDirectEntity();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            if (this.isSleeping()) {
                projectile.setDeltaMovement(projectile.getDeltaMovement().scale(-1.0));
                return false;
            }
        }
        return super.hurt(source, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        int sleeperType = this.random.nextIntBetweenInclusive(0, 2);
        this.setSleeperType(sleeperType);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        Item itemForTaming;
        ItemStack stackInHand = player.getItemInHand(hand);
        Item item = stackInHand.getItem();
        if (item == (itemForTaming = Items.MELON_SLICE) && this.getHealth() < this.getMaxHealth()) {
            FoodProperties foodComponent;
            if (!player.getAbilities().instabuild) {
                stackInHand.shrink(1);
            }
            float nutrition = (foodComponent = (FoodProperties)stackInHand.get(DataComponents.FOOD)) != null ? (float)foodComponent.nutrition() : 1.0f;
            this.heal(2.0f * nutrition);
            return InteractionResult.SUCCESS;
        }
        if (item == itemForTaming && !this.isTame()) {
            this.playSound(SoundEvents.HORSE_EAT, 1.0f, 1.25f);
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                stackInHand.shrink(1);
            }
            if (this.random.nextInt(3) == 0 && !this.level().isClientSide()) {
                super.tame(player);
                this.navigation.recomputePath();
                this.setHealth(this.getMaxHealth());
                this.setTarget(null);
                this.setTame(true, true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
                this.setIsForceSleeping(true);
                this.setIsSleeping(true);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && !this.level().isClientSide() && hand == InteractionHand.MAIN_HAND && !stackInHand.is(Items.MELON_SLICE) && !stackInHand.is(Items.MELON) && this.isOwnedBy((LivingEntity)player)) {
            this.setIsForceSleeping(!this.isSleeping());
            this.setIsSleeping(!this.isSleeping());
            return InteractionResult.SUCCESS;
        }
        if (stackInHand.getItem() == itemForTaming) {
            return InteractionResult.PASS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.is(Items.MELON);
    }

    public boolean isForceSleeping() {
        return (Boolean)this.entityData.get(FORCE_SLEEPING);
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(IS_SLEEPING);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setIsSleeping(nbt.getBoolean("IsSleeping"));
        this.setIsForceSleeping(nbt.getBoolean("IsForceSleeping"));
        this.setSleeperType(nbt.getInt("Sleeper"));
    }

    public int sleeperType() {
        return (Integer)this.entityData.get(SLEEPER);
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && !this.isTame()) {
            this.setIsSleeping(!this.level().isDay());
        }
        if (!this.level().isClientSide && this.isTame()) {
            this.setIsSleeping(this.isForceSleeping());
        }
        if (this.isSleeping()) {
            this.healNearbyEntities((Entity)this, 4.0);
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("IsSleeping", this.isSleeping());
        nbt.putBoolean("IsForceSleeping", this.isForceSleeping());
        nbt.putInt("Sleeper", this.sleeperType());
    }

    void setIsForceSleeping(boolean isSleeping) {
        this.entityData.set(FORCE_SLEEPING, (Object)isSleeping);
    }

    void setIsSleeping(boolean isSleeping) {
        this.entityData.set(IS_SLEEPING, (Object)isSleeping);
    }

    void setSleeperType(int type) {
        this.entityData.set(SLEEPER, (Object)type);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_SLEEPING, (Object)false);
        builder.define(FORCE_SLEEPING, (Object)false);
        builder.define(SLEEPER, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new CapybaraSitGoal(this, this));
        this.goalSelector.addGoal(3, (Goal)new CapybaraEscapeDangerGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(4, (Goal)new CapybaraMateGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new CapybaraFollowOwnerGoal(this, 1.2, 10.0f, 2.0f));
        this.goalSelector.addGoal(6, (Goal)new CapybaraTemptGoal((PathfinderMob)this, 1.2, BREEDING_INGREDIENT, false));
        this.goalSelector.addGoal(7, (Goal)new FollowParentGoal((Animal)this, 1.2));
        this.goalSelector.addGoal(8, (Goal)new CapybaraWanderGoal((PathfinderMob)this, 1.0, 0.3f));
        this.goalSelector.addGoal(9, (Goal)new CapybaraLookAtEntityGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new CapybaraLookAroundGoal((Mob)this));
    }

    protected void updateWalkAnimation(float v) {
        float f = this.getPose() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f * 2.0f, 0.3f);
    }

    private void pickRandomIdleAnim(boolean bl) {
        if (bl) {
            this.earTwitchAnimationStateOne.start(this.tickCount);
        } else {
            this.earTwitchAnimationStateTwo.start(this.tickCount);
        }
    }

    private void setupAnimationStates() {
        if (this.sleepingAnimationTimeout <= 0) {
            this.sleepingAnimationTimeout = 80;
            this.sleepingAnimationState.start(this.tickCount);
        } else {
            --this.sleepingAnimationTimeout;
        }
        if (this.earTwitchAnimationTimeout <= 0 && this.random.nextInt(100) == 0) {
            this.earTwitchAnimationTimeout = 3;
            this.pickRandomIdleAnim(this.random.nextBoolean());
        } else {
            --this.earTwitchAnimationTimeout;
        }
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.CAPYBARAS_SPAWN_ON);
    }

    private class CapybaraSitGoal
    extends SitWhenOrderedToGoal {
        private final CapybaraEntity capybara;

        public CapybaraSitGoal(CapybaraEntity capybaraEntity, CapybaraEntity capybara) {
            super((TamableAnimal)capybara);
            this.capybara = capybara;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            super.canUse();
            return this.capybara.isForceSleeping();
        }

        public boolean canContinueToUse() {
            return this.capybara.isForceSleeping() || this.capybara.isOrderedToSit();
        }

        public void start() {
            this.capybara.getNavigation().stop();
            this.capybara.setIsForceSleeping(true);
        }

        public void stop() {
            this.capybara.setIsForceSleeping(false);
            this.capybara.setInSittingPose(false);
        }
    }

    private class CapybaraEscapeDangerGoal
    extends PanicGoal {
        public CapybaraEscapeDangerGoal(PathfinderMob mob, double speed) {
            super(mob, speed);
        }

        public boolean canUse() {
            return super.canUse() && !CapybaraEntity.this.isSleeping();
        }
    }

    private class CapybaraMateGoal
    extends BreedGoal {
        public CapybaraMateGoal(Animal animal, double speed) {
            super(animal, speed);
        }

        public boolean canUse() {
            return super.canUse() && !CapybaraEntity.this.isSleeping();
        }
    }

    private class CapybaraFollowOwnerGoal
    extends FollowOwnerGoal {
        public CapybaraFollowOwnerGoal(ParentTameableEntity tameable, double speed, float minDistance, float maxDistance) {
            super((TamableAnimal)tameable, speed, minDistance, maxDistance);
        }

        public boolean canUse() {
            return super.canUse() && !CapybaraEntity.this.isSleeping();
        }
    }

    private class CapybaraTemptGoal
    extends TemptGoal {
        public CapybaraTemptGoal(PathfinderMob entity, double speed, Ingredient food, boolean canBeScared) {
            super(entity, speed, (Predicate)food, canBeScared);
        }

        public boolean canUse() {
            return super.canUse() && !CapybaraEntity.this.isSleeping();
        }
    }

    private class CapybaraWanderGoal
    extends WaterAvoidingRandomStrollGoal {
        public CapybaraWanderGoal(PathfinderMob mob, double speed, float probability) {
            super(mob, speed, probability);
        }

        public boolean canUse() {
            return super.canUse() && !CapybaraEntity.this.isSleeping();
        }

        public void tick() {
            if (CapybaraEntity.this.isSleeping()) {
                this.stop();
                this.mob.getNavigation().stop();
            }
            super.tick();
        }
    }

    private class CapybaraLookAtEntityGoal
    extends LookAtPlayerGoal {
        public CapybaraLookAtEntityGoal(Mob mob, Class<? extends LivingEntity> targetType, float range) {
            super(mob, targetType, range);
        }

        public boolean canUse() {
            return super.canUse() && !CapybaraEntity.this.isSleeping();
        }
    }

    private class CapybaraLookAroundGoal
    extends RandomLookAroundGoal {
        public CapybaraLookAroundGoal(Mob mob) {
            super(mob);
        }

        public boolean canUse() {
            return super.canUse() && !CapybaraEntity.this.isSleeping();
        }
    }
}

