/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import net.emilsg.clutterbestiary.entity.custom.goal.BoopletWanderGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.TrackedFleeGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.sound.ModSoundEvents;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.emilsg.clutterbestiary.util.ModUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;

public class BoopletEntity
extends ParentAnimalEntity
implements Shearable {
    private static final EntityDataAccessor<Boolean> IS_FLUFFY = SynchedEntityData.defineId(BoopletEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> FLUFF_TIMER = SynchedEntityData.defineId(BoopletEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState happyAnimationState = new AnimationState();
    public final AnimationState boopAnimationState = new AnimationState();
    public final AnimationState swimAnimationState = new AnimationState();
    private boolean isBooped = false;
    private int timeSinceBoop = 0;
    private int happyDanceTimer = 0;
    private int happyAnimationTimer = 0;
    private int swimAnimationTimeout = 0;
    private boolean isHappy = false;
    private Player lastPetPlayer = null;

    public BoopletEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -2.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.SHEARS)) {
            if (!this.level().isClientSide && this.isFluffy()) {
                this.shear(SoundSource.PLAYERS);
                this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            player.swing(InteractionHand.MAIN_HAND);
            if (!player.level().isClientSide) {
                this.playSound(ModSoundEvents.ENTITY_BOOPLET_SQUEAK.get(), this.getSoundVolume() / 2.0f, this.getVoicePitch());
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ModUtil.grantImpossibleAdvancement("bestiary/boop", serverWorld, player);
                }
            }
            if (this.canBeHappy()) {
                this.lastPetPlayer = player;
                this.isHappy = true;
                this.getLookControl().setLookAt((Entity)player);
            } else {
                this.isBooped = true;
                this.timeSinceBoop = 0;
            }
            this.getNavigation().stop();
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ParentAnimalEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, (double)0.18f).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public boolean canBeHappy() {
        return this.hurtTime <= 0 && this.random.nextInt(20) == 0 && this.happyDanceTimer <= 0 && !this.isInWaterOrRain();
    }

    public int getFluffTimer() {
        return (Integer)this.entityData.get(FLUFF_TIMER);
    }

    public void setFluffTimer(int fluffTimer) {
        this.entityData.set(FLUFF_TIMER, (Object)fluffTimer);
    }

    public int getTimeSinceBoop() {
        return this.timeSinceBoop;
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return false;
    }

    public boolean isFluffy() {
        return (Boolean)this.entityData.get(IS_FLUFFY);
    }

    public boolean readyForShearing() {
        return this.isFluffy();
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.setIsFluffy(nbt.getBoolean("IsFluffy"));
        this.setFluffTimer(nbt.getInt("FluffTimer"));
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.BOOPLETS_SPAWN_ON);
    }

    public void setIsFluffy(boolean fluffy) {
        this.entityData.set(IS_FLUFFY, (Object)fluffy);
    }

    public void shear(SoundSource shearedSoundCategory) {
        this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, shearedSoundCategory, 1.0f, 1.25f);
        this.setIsFluffy(false);
        this.setFluffTimer(0);
        int droppedAmount = 1 + this.random.nextInt(3);
        for (int j = 0; j < droppedAmount; ++j) {
            ItemEntity itemEntity = this.spawnAtLocation((ItemLike)Items.STRING, 0);
            if (itemEntity == null) continue;
            itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
        }
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (this.timeSinceBoop <= 10) {
            ++this.timeSinceBoop;
        }
        if (this.happyDanceTimer > 0) {
            --this.happyDanceTimer;
        }
        if (this.happyAnimationTimer > 0) {
            this.getNavigation().stop();
        }
        if (world.isClientSide) {
            this.setupAnimationStates();
            if (this.isBooped && !this.isHappy) {
                this.stopAndOrRestartBoopAnimation(true);
            } else if (this.isHappy) {
                this.stopAndOrRestartBoopAnimation(false);
                this.happyDanceTimer = 600;
                this.happyAnimationState.start(this.tickCount);
                this.happyAnimationTimer = 80;
                this.isHappy = false;
            }
        } else if (!this.isFluffy()) {
            int fluffTimer = this.getFluffTimer();
            if (fluffTimer < 5000) {
                this.setFluffTimer(fluffTimer++);
            }
            this.setIsFluffy(fluffTimer >= 5000);
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("IsFluffy", this.isFluffy());
        nbt.putInt("FluffTimer", this.getFluffTimer());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_FLUFFY, (Object)true);
        builder.define(FLUFF_TIMER, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TrackedFleeGoal(this, 1.5));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(4, (Goal)new BoopletWanderGoal(this, 1.0f));
    }

    protected void updateWalkAnimation(float v) {
        float f = this.getPose() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f * 2.5f, 0.2f);
    }

    private void setupAnimationStates() {
        if (this.happyAnimationTimer > 0) {
            --this.happyAnimationTimer;
        }
        if (this.happyAnimationTimer <= 0 || this.hurtTime > 0) {
            this.happyAnimationState.stop();
        }
        if (this.swimAnimationTimeout <= 0 && this.isInWater()) {
            this.swimAnimationTimeout = 20;
            this.swimAnimationState.start(this.tickCount);
        } else {
            --this.swimAnimationTimeout;
        }
    }

    private void stopAndOrRestartBoopAnimation(boolean restart) {
        this.boopAnimationState.stop();
        if (restart) {
            this.boopAnimationState.start(this.tickCount);
            this.isBooped = false;
        }
    }
}

