/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.PotionWaspEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.BestiaryModel;
import net.emilsg.clutterbestiary.entity.custom.PotionWaspEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class PotionWaspModel<T extends PotionWaspEntity>
extends BestiaryModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart potionSac;
    private final ModelPart head;

    public PotionWaspModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
        this.body = this.all.getChild("body");
        this.potionSac = this.body.getChild("potionSac");
        this.head = this.body.getChild("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)15.0f, (float)0.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(24, 15).addBox(-2.0f, -1.5f, -3.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-0.5f, (float)-0.5f));
        PartDefinition potionSac = body.addOrReplaceChild("potionSac", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.5f, (float)0.5f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(24, 24).addBox(-1.5f, -1.0f, -1.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(-1, 15).addBox(-1.0f, 0.0f, 0.0f, 4.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-1.5f, (float)-2.0f));
        PartDefinition rightWing = body.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(0, 24).addBox(-3.0f, 0.0f, 0.0f, 4.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-1.5f, (float)-2.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(28, 0).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)-3.0f));
        PartDefinition leftInnerMandible = head.addOrReplaceChild("leftInnerMandible", CubeListBuilder.create().texOffs(24, 30).addBox(0.0f, -0.5f, -1.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.5f, (float)-1.5f, (float)0.0f, (float)-0.1309f, (float)0.0f));
        PartDefinition leftOuterMandible = leftInnerMandible.addOrReplaceChild("leftOuterMandible", CubeListBuilder.create().texOffs(26, 30).addBox(0.0f, -0.5f, -1.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition rightInnerMandible = head.addOrReplaceChild("rightInnerMandible", CubeListBuilder.create().texOffs(28, 30).addBox(0.0f, -0.5f, -1.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.5f, (float)-1.5f, (float)0.0f, (float)0.1309f, (float)0.0f));
        PartDefinition rightOuterMandible = rightInnerMandible.addOrReplaceChild("rightOuterMandible", CubeListBuilder.create().texOffs(30, 29).addBox(0.0f, -0.5f, -1.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        PartDefinition innerRightFrontLeg = body.addOrReplaceChild("innerRightFrontLeg", CubeListBuilder.create().texOffs(28, 10).addBox(-2.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.5f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition outerRightFrontLeg = innerRightFrontLeg.addOrReplaceChild("outerRightFrontLeg", CubeListBuilder.create().texOffs(28, 11).addBox(-2.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3963f));
        PartDefinition innerRightMiddleLeg = body.addOrReplaceChild("innerRightMiddleLeg", CubeListBuilder.create().texOffs(28, 12).addBox(-2.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition outerRightMiddleLeg = innerRightMiddleLeg.addOrReplaceChild("outerRightMiddleLeg", CubeListBuilder.create().texOffs(28, 13).addBox(-2.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5272f));
        PartDefinition innerRightBackLeg = body.addOrReplaceChild("innerRightBackLeg", CubeListBuilder.create().texOffs(28, 14).addBox(-2.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.5f, (float)2.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition outerRightBackLeg = innerRightBackLeg.addOrReplaceChild("outerRightBackLeg", CubeListBuilder.create().texOffs(24, 29).addBox(-2.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3963f));
        PartDefinition innerLeftFrontLeg = body.addOrReplaceChild("innerLeftFrontLeg", CubeListBuilder.create().texOffs(28, 4).addBox(0.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.5f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition outerLeftFrontLeg = innerLeftFrontLeg.addOrReplaceChild("outerLeftFrontLeg", CubeListBuilder.create().texOffs(28, 5).addBox(0.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.3963f));
        PartDefinition innerLeftMiddleLeg = body.addOrReplaceChild("innerLeftMiddleLeg", CubeListBuilder.create().texOffs(28, 6).addBox(0.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition outerLeftMiddleLeg = innerLeftMiddleLeg.addOrReplaceChild("outerLeftMiddleLeg", CubeListBuilder.create().texOffs(28, 7).addBox(0.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5272f));
        PartDefinition innerLeftBackLeg = body.addOrReplaceChild("innerLeftBackLeg", CubeListBuilder.create().texOffs(28, 8).addBox(0.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.5f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition outerLeftBackLeg = innerLeftBackLeg.addOrReplaceChild("outerLeftBackLeg", CubeListBuilder.create().texOffs(28, 9).addBox(0.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.3963f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public ModelPart getPotionSacPart() {
        return this.potionSac;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.root().render(matrices, vertices, light, overlay, color);
    }

    @Override
    public void setAngles(PotionWaspEntity potionWasp, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setHeadAngles((LivingEntity)potionWasp, netHeadYaw, headPitch, ageInTicks);
        this.getPotionSacPart().skipDraw = !potionWasp.hasPotionSac();
        this.animate(potionWasp.flyingAnimState, potionWasp.hasPotionSac() ? PotionWaspEntityAnimations.POTIONWASP_FLY : PotionWaspEntityAnimations.POTIONWASP_FLY_NO_SAC, ageInTicks, 1.0f);
    }

    @Override
    protected ModelPart getHeadPart() {
        return this.head;
    }
}

