/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.NetherNewtEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.ParentTameableModel;
import net.emilsg.clutterbestiary.entity.custom.AbstractNetherNewtEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class NetherNewtModel<T extends AbstractNetherNewtEntity>
extends ParentTameableModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart frontMushroom;
    private final ModelPart middleRightMushroom;
    private final ModelPart middleLeftMushroom;
    private final ModelPart backLeftMushroom;
    private final ModelPart backRightMushroom;

    public NetherNewtModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
        this.body = this.all.getChild("body");
        this.head = this.body.getChild("head");
        this.frontMushroom = this.body.getChild("frontMushroom");
        this.middleRightMushroom = this.body.getChild("middleRightMushroom");
        this.middleLeftMushroom = this.body.getChild("middleLeftMushroom");
        this.backLeftMushroom = this.body.getChild("backLeftMushroom");
        this.backRightMushroom = this.body.getChild("backRightMushroom");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)-2.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(13, 4).addBox(0.0f, -3.25f, -4.75f, 0.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.75f, (float)2.75f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.5f, -3.5f, 3.0f, 3.0f, 7.0f, new CubeDeformation(0.125f)).texOffs(0, 10).addBox(-1.5f, -1.5f, -3.5f, 3.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.25f, (float)-2.25f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(3, 15).addBox(-2.3f, -2.5f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.25f)).texOffs(13, 5).addBox(1.3f, -2.5f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.25f)).texOffs(13, 0).addBox(-1.5f, -2.0f, -3.5f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.15f, -1.0f, -3.3f, 2.3f, 0.25f, 2.55f, new CubeDeformation(0.0f)).texOffs(18, 18).addBox(-2.5f, -2.975f, -4.5f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(13, 12).addBox(-2.5f, -2.975f, -4.5f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.125f)), PartPose.offset((float)0.0f, (float)-0.25f, (float)-5.75f));
        PartDefinition Neck_r1 = head.addOrReplaceChild("Neck_r1", CubeListBuilder.create().texOffs(0, 25).addBox(-1.0f, -0.5f, -0.25f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(0, 31).addBox(-1.25f, 0.0f, -2.5f, 2.5f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 2).addBox(-1.0f, -0.25f, -2.25f, 2.0f, 0.25f, 1.75f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition beard = jaw.addOrReplaceChild("beard", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -1.5f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-1.0f));
        PartDefinition frontMushroom = body.addOrReplaceChild("frontMushroom", CubeListBuilder.create().texOffs(12, 28).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(8, 25).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(27, 25).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-4.25f));
        PartDefinition middleRightMushroom = body.addOrReplaceChild("middleRightMushroom", CubeListBuilder.create().texOffs(27, 6).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 22).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(6, 25).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.9f, (float)-1.0f, (float)-2.25f));
        PartDefinition middleLeftMushroom = body.addOrReplaceChild("middleLeftMushroom", CubeListBuilder.create().texOffs(29, 0).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 10).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(27, 28).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.9f, (float)-1.0f, (float)-2.25f));
        PartDefinition backLeftMushroom = body.addOrReplaceChild("backLeftMushroom", CubeListBuilder.create().texOffs(20, 16).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(23, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(17, 5).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.9f, (float)-1.0f, (float)-0.25f));
        PartDefinition backRightMushroom = body.addOrReplaceChild("backRightMushroom", CubeListBuilder.create().texOffs(19, 29).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 14).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(15, 29).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.9f, (float)-1.0f, (float)0.75f));
        PartDefinition upperLeftFrontLeg = body.addOrReplaceChild("upperLeftFrontLeg", CubeListBuilder.create().texOffs(8, 28).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.125f)), PartPose.offsetAndRotation((float)1.5f, (float)-0.25f, (float)-3.75f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition lowerLeftFrontLeg = upperLeftFrontLeg.addOrReplaceChild("lowerLeftFrontLeg", CubeListBuilder.create().texOffs(27, 3).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition upperRightFrontLeg = body.addOrReplaceChild("upperRightFrontLeg", CubeListBuilder.create().texOffs(24, 26).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.125f)), PartPose.offsetAndRotation((float)-1.5f, (float)-0.25f, (float)-3.75f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition lowerRightFrontLeg = upperRightFrontLeg.addOrReplaceChild("lowerRightFrontLeg", CubeListBuilder.create().texOffs(20, 26).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition upperLeftBackLeg = body.addOrReplaceChild("upperLeftBackLeg", CubeListBuilder.create().texOffs(16, 26).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.125f)), PartPose.offsetAndRotation((float)1.5f, (float)-0.25f, (float)0.25f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition lowerLeftBackLeg = upperLeftBackLeg.addOrReplaceChild("lowerLeftBackLeg", CubeListBuilder.create().texOffs(7, 20).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition upperRightBackLeg = body.addOrReplaceChild("upperRightBackLeg", CubeListBuilder.create().texOffs(13, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.125f)), PartPose.offsetAndRotation((float)-1.5f, (float)-0.25f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition lowerRightBackLeg = upperRightBackLeg.addOrReplaceChild("lowerRightBackLeg", CubeListBuilder.create().texOffs(0, 13).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition tailOne = body.addOrReplaceChild("tailOne", CubeListBuilder.create().texOffs(10, 20).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.25f)).texOffs(0, 2).addBox(0.0f, -2.25f, 0.175f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.45f, (float)1.25f));
        PartDefinition tailTwo = tailOne.addOrReplaceChild("tailTwo", CubeListBuilder.create().texOffs(20, 5).addBox(-1.0f, -1.0f, -0.35f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 1).addBox(0.0f, -1.9f, 0.675f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.15f, (float)3.25f));
        PartDefinition tailThree = tailTwo.addOrReplaceChild("tailThree", CubeListBuilder.create().texOffs(0, 20).addBox(-1.0f, -1.0f, -0.3f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.25f)).texOffs(2, 1).addBox(0.0f, -1.7f, 0.675f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.15f, (float)2.6f));
        PartDefinition tailFour = tailThree.addOrReplaceChild("tailFour", CubeListBuilder.create().texOffs(0, 10).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.15f, (float)2.45f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        if (this.young) {
            float babyScale = 0.5f;
            this.head.offsetScale(this.createVec3f(babyScale));
            matrices.pushPose();
            matrices.scale(babyScale, babyScale, babyScale);
            matrices.translate(0.0, 1.5, 0.0);
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
            this.head.offsetScale(this.createVec3f(0.9f));
        } else {
            matrices.pushPose();
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
        }
    }

    @Override
    public void setAngles(AbstractNetherNewtEntity newt, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setHeadAngles((LivingEntity)newt, netHeadYaw, headPitch, ageInTicks);
        if (!newt.isOrderedToSit()) {
            this.animateWalk(NetherNewtEntityAnimations.NETHER_NEWT_WALK, limbSwing, limbSwingAmount, 1.5f, 2.0f);
            this.animate(newt.idleAnimationState, NetherNewtEntityAnimations.NETHER_NEWT_IDLE, ageInTicks, 1.0f);
        } else {
            this.animate(newt.sittingAnimationState, NetherNewtEntityAnimations.NETHER_NEWT_SIT, ageInTicks, 1.0f);
        }
        this.updateVisibleParts(newt);
    }

    @Override
    protected ModelPart getHeadPart() {
        return this.head;
    }

    private void updateVisibleParts(AbstractNetherNewtEntity netherNewtEntity) {
        int fungiCount = netherNewtEntity.getFungiCount();
        this.frontMushroom.visible = fungiCount >= 1;
        this.middleRightMushroom.visible = fungiCount >= 4;
        this.middleLeftMushroom.visible = fungiCount >= 2;
        this.backLeftMushroom.visible = fungiCount >= 5;
        this.backRightMushroom.visible = fungiCount >= 3;
    }
}

