/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.MossbloomEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.ParentTameableModel;
import net.emilsg.clutterbestiary.entity.custom.MossbloomEntity;
import net.emilsg.clutterbestiary.entity.variants.MossbloomVariant;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class MossbloomModel<T extends MossbloomEntity>
extends ParentTameableModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart neck;
    private final ModelPart leftHorn;
    private final ModelPart rightHorn;
    private final ModelPart torso;
    private final ModelPart neckTwo;
    private final ModelPart head;
    private final ModelPart saddle;

    public MossbloomModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
        this.neck = this.all.getChild("neck");
        this.neckTwo = this.neck.getChild("neckTwo");
        this.head = this.neckTwo.getChild("head");
        this.leftHorn = this.head.getChild("leftHorn");
        this.rightHorn = this.head.getChild("rightHorn");
        this.torso = this.all.getChild("torso");
        this.saddle = this.torso.getChild("saddle");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)11.0f, (float)0.0f));
        PartDefinition neck = all.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)-6.5f));
        PartDefinition neck_r1 = neck.addOrReplaceChild("neck_r1", CubeListBuilder.create().texOffs(26, 0).addBox(-2.0f, -2.5f, -2.5f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0784f, (float)-0.0982f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition neckTwo = neck.addOrReplaceChild("neckTwo", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition neckTwo_r1 = neckTwo.addOrReplaceChild("neckTwo_r1", CubeListBuilder.create().texOffs(40, 13).addBox(-2.0f, -2.0f, -5.275f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-1.0f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition head = neckTwo.addOrReplaceChild("head", CubeListBuilder.create().texOffs(27, 11).addBox(-2.5f, -7.0f, -7.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(52, 0).addBox(-1.5f, -5.0f, -10.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 37).addBox(0.0f, -2.0f, -10.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)1.0f));
        PartDefinition leftEar = head.addOrReplaceChild("leftEar", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)-6.0f, (float)-3.5f));
        PartDefinition leftEar_r1 = leftEar.addOrReplaceChild("leftEar_r1", CubeListBuilder.create().texOffs(24, 21).addBox(-1.0f, -1.0f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition rightEar = head.addOrReplaceChild("rightEar", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)-6.0f, (float)-3.5f));
        PartDefinition rightEar_r1 = rightEar.addOrReplaceChild("rightEar_r1", CubeListBuilder.create().texOffs(34, 8).addBox(-2.0f, -1.0f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition leftHorn = head.addOrReplaceChild("leftHorn", CubeListBuilder.create().texOffs(32, 48).mirror().addBox(-4.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(32, 32).mirror().addBox(-4.0f, -13.0f, -0.01f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)-7.0f, (float)-5.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        PartDefinition rightHorn = head.addOrReplaceChild("rightHorn", CubeListBuilder.create().texOffs(32, 32).addBox(-12.0f, -13.0f, -0.01f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(32, 48).addBox(-12.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-7.0f, (float)-5.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        PartDefinition torso = all.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -8.5f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-4.0f, -3.0f, -0.5f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 48).addBox(-4.0f, -4.0f, -8.5f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.5f));
        PartDefinition tail = torso.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)6.5f));
        PartDefinition tail_r1 = tail.addOrReplaceChild("tail_r1", CubeListBuilder.create().texOffs(36, 2).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition saddle = torso.addOrReplaceChild("saddle", CubeListBuilder.create().texOffs(62, 0).addBox(-4.5f, -4.35f, -5.0f, 9.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition frontLeftLeg = all.addOrReplaceChild("frontLeftLeg", CubeListBuilder.create().texOffs(24, 35).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)4.0f, (float)-6.0f));
        PartDefinition frontRightLeg = all.addOrReplaceChild("frontRightLeg", CubeListBuilder.create().texOffs(16, 31).addBox(0.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)4.0f, (float)-6.0f));
        PartDefinition backLeftLeg = all.addOrReplaceChild("backLeftLeg", CubeListBuilder.create().texOffs(8, 31).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)4.0f, (float)6.0f));
        PartDefinition backRightLeg = all.addOrReplaceChild("backRightLeg", CubeListBuilder.create().texOffs(0, 31).addBox(0.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)4.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)96, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        if (this.young) {
            float babyScale = 0.75f;
            matrices.pushPose();
            matrices.scale(babyScale, babyScale, babyScale);
            matrices.translate(0.0, 0.5, 0.0);
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
            this.getHeadPart().offsetScale(this.createVec3f(1.0f));
        } else {
            matrices.pushPose();
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
        }
    }

    @Override
    public void setAngles(MossbloomEntity mossbloom, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setHeadAngles((LivingEntity)mossbloom, netHeadYaw, headPitch, ageInTicks);
        this.updateVisibleParts(mossbloom);
        this.animateWalk(mossbloom.isFleeing() || mossbloom.getSprinting() ? MossbloomEntityAnimations.MOSSBLOOM_RUN : MossbloomEntityAnimations.MOSSBLOOM_WALK, limbSwing, limbSwingAmount, 1.5f, 2.0f);
        if (mossbloom.isVariantOf(MossbloomVariant.HORNED)) {
            this.animate(mossbloom.shakingAnimationState, MossbloomEntityAnimations.MOSSBLOOM_SHAKE_HEAD, ageInTicks, 1.0f);
        }
        this.animate(mossbloom.idleAnimationState, MossbloomEntityAnimations.MOSSBLOOM_IDLE, ageInTicks, 1.0f);
        this.animate(mossbloom.earTwitchAnimationStateLE, MossbloomEntityAnimations.MOSSBLOOM_LE_DROP, ageInTicks, 2.0f);
        this.animate(mossbloom.earTwitchAnimationStateRE, MossbloomEntityAnimations.MOSSBLOOM_RE_DROP, ageInTicks, 2.0f);
        this.animate(mossbloom.earTwitchAnimationStateBE, MossbloomEntityAnimations.MOSSBLOOM_EARS_DROP, ageInTicks, 2.0f);
        this.animate(mossbloom.wagTailAnimationStateBE, MossbloomEntityAnimations.MOSSBLOOM_WAG_TAIL, ageInTicks, 2.0f);
    }

    @Override
    protected ModelPart getHeadPart() {
        return this.neck;
    }

    private void updateVisibleParts(MossbloomEntity mossbloom) {
        boolean horns = mossbloom.getHasHorns();
        boolean hasSaddle = mossbloom.getIsSaddled();
        this.leftHorn.visible = horns && !mossbloom.isBaby();
        this.rightHorn.visible = horns && !mossbloom.isBaby();
        this.saddle.visible = hasSaddle && !mossbloom.isBaby();
    }
}

