/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.EmperorPenguinEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.BestiaryModel;
import net.emilsg.clutterbestiary.entity.custom.EmperorPenguinEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class EmperorPenguinModel<T extends EmperorPenguinEntity>
extends BestiaryModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart head;

    public EmperorPenguinModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("All");
        this.head = this.all.getChild("Head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition All = modelPartData.addOrReplaceChild("All", CubeListBuilder.create().texOffs(45, 17).addBox(-3.0f, 9.0f, 2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 41).addBox(-4.0f, -6.0f, -4.0f, 8.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(-4.0f, -6.0f, -5.0f, 8.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition Head = All.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(38, 52).addBox(-3.0f, -5.0f, -3.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition Beak = Head.addOrReplaceChild("Beak", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Upper = Beak.addOrReplaceChild("Upper", CubeListBuilder.create().texOffs(32, 46).addBox(-0.5f, -1.0f, -4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0625f)).texOffs(1, 1).addBox(-0.5f, 0.125f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0625f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-3.0f));
        PartDefinition Lower = Beak.addOrReplaceChild("Lower", CubeListBuilder.create().texOffs(33, 42).addBox(-0.5f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-3.0f));
        PartDefinition R_Wing = All.addOrReplaceChild("R_Wing", CubeListBuilder.create().texOffs(43, 37).addBox(-1.0f, 0.0f, -1.0f, 1.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition L_Wing = All.addOrReplaceChild("L_Wing", CubeListBuilder.create().texOffs(54, 37).addBox(0.0f, 0.0f, -1.0f, 1.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition L_Leg = All.addOrReplaceChild("L_Leg", CubeListBuilder.create().texOffs(47, 5).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(2, 13).addBox(-1.5f, 1.95f, -4.5f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)9.0f, (float)-0.5f));
        PartDefinition R_Leg = All.addOrReplaceChild("R_Leg", CubeListBuilder.create().texOffs(2, 5).addBox(-1.5f, 1.95f, -4.5f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(47, 11).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)9.0f, (float)-0.5f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.root().render(matrices, vertices, light, overlay, color);
    }

    @Override
    public void setAngles(EmperorPenguinEntity emperorPenguinEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setHeadAngles((LivingEntity)emperorPenguinEntity, headYaw, headPitch, ageInTicks);
        if (!emperorPenguinEntity.isInWater()) {
            this.animateWalk(EmperorPenguinEntityAnimations.EMPEROR_PENGUIN_WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        }
        this.animate(emperorPenguinEntity.flapAnimationStateOne, EmperorPenguinEntityAnimations.EMPEROR_PENGUIN_RANDOM_FLAP, ageInTicks, 1.0f);
        this.animate(emperorPenguinEntity.flapAnimationStateTwo, EmperorPenguinEntityAnimations.EMPEROR_PENGUIN_RANDOM_FLAP_TWO, ageInTicks, 1.0f);
        this.animate(emperorPenguinEntity.preenAnimationState, EmperorPenguinEntityAnimations.EMPEROR_PENGUIN_PREEN, ageInTicks, 1.0f);
    }

    @Override
    protected ModelPart getHeadPart() {
        return this.head;
    }
}

