/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.ButterflyEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.BestiaryModel;
import net.emilsg.clutterbestiary.entity.custom.ButterflyEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class ButterflyModel<T extends ButterflyEntity>
extends BestiaryModel<T> {
    private final ModelPart all;
    private final ModelPart root;

    public ButterflyModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(3, 3).addBox(0.25f, -1.8848f, -0.3293f, 0.5f, 4.0f, 0.5f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-0.1152f, (float)-0.4207f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(4, 3).addBox(0.0f, -1.0f, 0.0f, 0.25f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.25f, (float)-1.75f, (float)-0.25f, (float)0.2182f, (float)0.0f, (float)-0.2182f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(4, 3).addBox(-0.25f, -1.0f, 0.0f, 0.25f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.75f, (float)-1.75f, (float)-0.25f, (float)0.2182f, (float)0.0f, (float)0.2182f));
        PartDefinition leftWing = body.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(0, 8).mirror().addBox(0.0f, -3.8848f, -0.0793f, 4.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.75f, (float)0.0f, (float)0.0f));
        PartDefinition rightWing = body.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(0, 8).addBox(-4.0f, -3.8848f, -0.0793f, 4.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.25f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)16, (int)16);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.root().render(matrices, vertices, light, overlay, color);
    }

    @Override
    public void setAngles(ButterflyEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.flyingAnimState, switch (entity.getFlyingTypeVariant()) {
            case 1 -> ButterflyEntityAnimations.BUTTERFLY_FLYING_TWO;
            case 2 -> ButterflyEntityAnimations.BUTTERFLY_FLYING_THREE;
            default -> ButterflyEntityAnimations.BUTTERFLY_FLYING_ONE;
        }, ageInTicks, 1.0f);
    }

    @Override
    protected ModelPart getHeadPart() {
        return null;
    }
}

