/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.world;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class WorldChunkUtil {
    public static boolean isBlockLoaded(LevelAccessor world, BlockPos pos) {
        return WorldChunkUtil.isChunkLoaded(world, pos.getX() >> 4, pos.getZ() >> 4);
    }

    public static boolean isChunkLoaded(LevelAccessor world, int x, int z) {
        if (world.getChunkSource() instanceof ServerChunkCache) {
            ChunkHolder holder = ((ServerChunkCache)world.getChunkSource()).chunkMap.getVisibleChunkIfPresent(ChunkPos.asLong((int)x, (int)z));
            if (holder != null) {
                return holder.getFullChunkFuture().getNow(ChunkHolder.UNLOADED_LEVEL_CHUNK).isSuccess();
            }
            return false;
        }
        return world.getChunk(x, z, ChunkStatus.FULL, false) != null;
    }

    public static boolean isChunkLoaded(LevelAccessor world, ChunkPos pos) {
        return WorldChunkUtil.isChunkLoaded(world, pos.x, pos.z);
    }

    public static boolean isEntityBlockLoaded(LevelAccessor world, BlockPos pos) {
        return WorldChunkUtil.isEntityChunkLoaded(world, pos.getX() >> 4, pos.getZ() >> 4);
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, int x, int z) {
        return WorldChunkUtil.isEntityChunkLoaded(world, new ChunkPos(x, z));
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, ChunkPos pos) {
        if (world instanceof ServerLevel) {
            return WorldChunkUtil.isChunkLoaded(world, pos) && ((ServerLevel)world).isPositionEntityTicking(pos.getWorldPosition());
        }
        return WorldChunkUtil.isChunkLoaded(world, pos);
    }
}

