/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.world;

import com.github.alexthe666.citadel.server.tick.ServerTickRateTracker;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CitadelServerData
extends SavedData {
    private static Map<MinecraftServer, CitadelServerData> dataMap = new HashMap<MinecraftServer, CitadelServerData>();
    private static final String IDENTIFIER = "citadel_world_data";
    private MinecraftServer server;
    private ServerTickRateTracker tickRateTracker = null;

    public CitadelServerData(MinecraftServer server) {
        this.server = server;
    }

    public static SavedData.Factory<CitadelServerData> factory(MinecraftServer level) {
        return new SavedData.Factory(() -> new CitadelServerData(level), (tag, provider) -> CitadelServerData.load(level, tag), null);
    }

    public static CitadelServerData get(MinecraftServer server) {
        CitadelServerData fromMap = dataMap.get(server);
        if (fromMap == null) {
            DimensionDataStorage storage = server.getLevel(Level.OVERWORLD).getDataStorage();
            CitadelServerData data = (CitadelServerData)storage.computeIfAbsent(CitadelServerData.factory(server), IDENTIFIER);
            data.setDirty();
            dataMap.put(server, data);
            return data;
        }
        return fromMap;
    }

    public static CitadelServerData load(MinecraftServer server, CompoundTag tag) {
        CitadelServerData data = new CitadelServerData(server);
        data.tickRateTracker = tag.contains("TickRateTracker") ? new ServerTickRateTracker(server, tag.getCompound("TickRateTracker")) : new ServerTickRateTracker(server);
        return data;
    }

    public ServerTickRateTracker getOrCreateTickRateTracker() {
        if (this.tickRateTracker == null) {
            this.tickRateTracker = new ServerTickRateTracker(this.server);
        }
        return this.tickRateTracker;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.tickRateTracker != null) {
            tag.put("TickRateTracker", (Tag)this.tickRateTracker.toTag());
        }
        return tag;
    }
}

