/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.message;

import com.github.alexthe666.citadel.client.render.pathfinding.PathfindingDebugRenderer;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.MNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncePathMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SyncePathMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"citadel", (String)"sync_path"));
    public static final StreamCodec<FriendlyByteBuf, SyncePathMessage> CODEC = StreamCodec.ofMember(SyncePathMessage::write, SyncePathMessage::read);
    public Set<MNode> lastDebugNodesVisited = new HashSet<MNode>();
    public Set<MNode> lastDebugNodesNotVisited = new HashSet<MNode>();
    public Set<MNode> lastDebugNodesPath = new HashSet<MNode>();

    public SyncePathMessage(Set<MNode> lastDebugNodesVisited, Set<MNode> lastDebugNodesNotVisited, Set<MNode> lastDebugNodesPath) {
        this.lastDebugNodesVisited = lastDebugNodesVisited;
        this.lastDebugNodesNotVisited = lastDebugNodesNotVisited;
        this.lastDebugNodesPath = lastDebugNodesPath;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.lastDebugNodesVisited.size());
        for (MNode MNode2 : this.lastDebugNodesVisited) {
            MNode2.serializeToBuf(buf);
        }
        buf.writeInt(this.lastDebugNodesNotVisited.size());
        for (MNode MNode2 : this.lastDebugNodesNotVisited) {
            MNode2.serializeToBuf(buf);
        }
        buf.writeInt(this.lastDebugNodesPath.size());
        for (MNode MNode2 : this.lastDebugNodesPath) {
            MNode2.serializeToBuf(buf);
        }
    }

    public static SyncePathMessage read(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashSet<MNode> lastDebugNodesVisited = new HashSet<MNode>();
        for (int i = 0; i < size; ++i) {
            lastDebugNodesVisited.add(new MNode(buf));
        }
        size = buf.readInt();
        HashSet<MNode> lastDebugNodesNotVisited = new HashSet<MNode>();
        for (int i = 0; i < size; ++i) {
            lastDebugNodesNotVisited.add(new MNode(buf));
        }
        size = buf.readInt();
        HashSet<MNode> lastDebugNodesPath = new HashSet<MNode>();
        for (int i = 0; i < size; ++i) {
            lastDebugNodesPath.add(new MNode(buf));
        }
        return new SyncePathMessage(lastDebugNodesVisited, lastDebugNodesNotVisited, lastDebugNodesPath);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncePathMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.flow().isClientbound()) {
                PathfindingDebugRenderer.lastDebugNodesVisited = message.lastDebugNodesVisited;
                PathfindingDebugRenderer.lastDebugNodesNotVisited = message.lastDebugNodesNotVisited;
                PathfindingDebugRenderer.lastDebugNodesPath = message.lastDebugNodesPath;
            }
        });
    }
}

