/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.generation;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.generation.IExtendedNoiseGeneratorSettings;
import com.github.alexthe666.citadel.server.generation.SurfaceRulesManager;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;

public class SurfaceRuleInitializer {
    public static void initializeOnServerStart(MinecraftServer server) {
        Citadel.LOGGER.info("[Citadel] SurfaceRuleInitializer: Starting initialization...");
        Citadel.LOGGER.info("[Citadel] OVERWORLD rules registered: {}", (Object)SurfaceRulesManager.hasRulesForCategory(SurfaceRulesManager.RuleCategory.OVERWORLD));
        RegistryAccess.Frozen registryAccess = server.registryAccess();
        Registry levelStemRegistry = registryAccess.registryOrThrow(Registries.LEVEL_STEM);
        for (Map.Entry entry : levelStemRegistry.entrySet()) {
            LevelStem stem = (LevelStem)entry.getValue();
            Citadel.LOGGER.info("[Citadel] Processing dimension: {}", (Object)((ResourceKey)entry.getKey()).location());
            SurfaceRuleInitializer.initializeSurfaceRules((Holder<DimensionType>)stem.type(), (ResourceKey<LevelStem>)((ResourceKey)entry.getKey()), stem.generator());
        }
        Citadel.LOGGER.info("[Citadel] SurfaceRuleInitializer: Initialization complete.");
    }

    private static void initializeSurfaceRules(Holder<DimensionType> dimensionType, ResourceKey<LevelStem> levelResourceKey, ChunkGenerator chunkGenerator) {
        if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) {
            return;
        }
        NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
        NoiseGeneratorSettings generatorSettings = (NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value();
        SurfaceRulesManager.RuleCategory ruleCategory = SurfaceRuleInitializer.getRuleCategoryForDimension(dimensionType);
        if (ruleCategory == null) {
            return;
        }
        if (!SurfaceRulesManager.hasRulesForCategory(ruleCategory)) {
            return;
        }
        if (!(generatorSettings instanceof IExtendedNoiseGeneratorSettings)) {
            Citadel.LOGGER.warn("NoiseGeneratorSettings mixin not applied, surface rules will not be injected for: {}", (Object)levelResourceKey.location());
            return;
        }
        ((IExtendedNoiseGeneratorSettings)generatorSettings).citadel$setRuleCategory(ruleCategory);
        Citadel.LOGGER.info("Initialized Citadel surface rules for dimension: {} (category: {})", (Object)levelResourceKey.location(), (Object)ruleCategory);
    }

    private static SurfaceRulesManager.RuleCategory getRuleCategoryForDimension(Holder<DimensionType> dimensionType) {
        DimensionType type = (DimensionType)dimensionType.value();
        if (type.ultraWarm()) {
            return SurfaceRulesManager.RuleCategory.NETHER;
        }
        if (!type.hasCeiling() && type.minY() == 0 && type.height() == 256 && !type.natural()) {
            return SurfaceRulesManager.RuleCategory.END;
        }
        if (type.natural()) {
            return SurfaceRulesManager.RuleCategory.OVERWORLD;
        }
        if (type.hasCeiling()) {
            return SurfaceRulesManager.RuleCategory.NETHER;
        }
        return SurfaceRulesManager.RuleCategory.OVERWORLD;
    }
}

