/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.event;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.util.TriState;

public class EventMergeStructureSpawns
extends Event {
    private StructureManager structureManager;
    private BlockPos pos;
    private MobCategory category;
    private WeightedRandomList<MobSpawnSettings.SpawnerData> structureSpawns;
    private WeightedRandomList<MobSpawnSettings.SpawnerData> biomeSpawns;
    private TriState result = TriState.DEFAULT;

    public EventMergeStructureSpawns(StructureManager structureManager, BlockPos pos, MobCategory category, WeightedRandomList<MobSpawnSettings.SpawnerData> structureSpawns, WeightedRandomList<MobSpawnSettings.SpawnerData> biomeSpawns) {
        this.structureManager = structureManager;
        this.pos = pos;
        this.category = category;
        this.structureSpawns = structureSpawns;
        this.biomeSpawns = biomeSpawns;
    }

    public StructureManager getStructureManager() {
        return this.structureManager;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public MobCategory getCategory() {
        return this.category;
    }

    public boolean isStructureTagged(TagKey<Structure> tagKey) {
        return this.structureManager.getStructureWithPieceAt(this.pos, tagKey).isValid();
    }

    public WeightedRandomList<MobSpawnSettings.SpawnerData> getStructureSpawns() {
        return this.structureSpawns;
    }

    public void setStructureSpawns(WeightedRandomList<MobSpawnSettings.SpawnerData> spawns) {
        this.structureSpawns = spawns;
    }

    public void mergeSpawns() {
        ArrayList<MobSpawnSettings.SpawnerData> list = new ArrayList<MobSpawnSettings.SpawnerData>(this.biomeSpawns.unwrap());
        for (MobSpawnSettings.SpawnerData structureSpawn : this.structureSpawns.unwrap()) {
            if (list.contains(structureSpawn)) continue;
            list.add(structureSpawn);
        }
        this.setStructureSpawns((WeightedRandomList<MobSpawnSettings.SpawnerData>)WeightedRandomList.create(list));
    }

    public WeightedRandomList<MobSpawnSettings.SpawnerData> getBiomeSpawns() {
        return this.biomeSpawns;
    }

    public TriState getResult() {
        return this.result;
    }

    public void setResult(TriState result) {
        this.result = result;
    }
}

