/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.pathjobs;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.AbstractAdvancedPathNavigate;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.ChunkCache;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.IPassabilityNavigator;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.ITallWalker;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.MNode;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.PathPointExtended;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.PathResult;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.Pathfinding;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.PathfindingConstants;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.PathingOptions;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.SurfaceType;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.pathjobs.ICustomSizeNavigator;
import com.github.alexthe666.citadel.server.message.SyncPathReachedMessage;
import com.github.alexthe666.citadel.server.message.SyncePathMessage;
import com.mojang.datafixers.util.Pair;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class AbstractPathJob
implements Callable<Path> {
    public static final Map<Player, UUID> trackingMap = new HashMap<Player, UUID>();
    protected final BlockPos start;
    protected final LevelReader world;
    protected final PathResult result;
    private final Queue<MNode> nodesOpen = new PriorityQueue<MNode>(500);
    private final Map<Integer, MNode> nodesVisited = new HashMap<Integer, MNode>();
    private final AbstractAdvancedPathNavigate.RestrictionType restrictionType;
    private final boolean hardXzRestriction;
    private final boolean xzRestricted = false;
    protected int maxRange;
    protected BlockPos end = null;
    protected boolean debugDrawEnabled = false;
    @Nullable
    protected Set<MNode> debugNodesVisited = new HashSet<MNode>();
    @Nullable
    protected Set<MNode> debugNodesNotVisited = new HashSet<MNode>();
    @Nullable
    protected Set<MNode> debugNodesPath = new HashSet<MNode>();
    protected WeakReference<LivingEntity> entity;
    IPassabilityNavigator passabilityNavigator;
    private boolean allowJumpPointSearchTypeWalk;
    private int entitySizeXZStart = 0;
    private int entitySizeXZEnd = 1;
    private int entitySizeY = 1;
    private int totalNodesAdded = 0;
    private int totalNodesVisited = 0;
    private PathingOptions pathingOptions = new PathingOptions();
    private int maxX;
    private int minX;
    private int maxZ;
    private int minZ;
    private int maxY;
    private int minY;
    private double maxJumpHeight = 1.3;
    private int maxNavigableGroundDist = 1;

    public AbstractPathJob(Level world, BlockPos start, BlockPos end, int range, LivingEntity entity) {
        this(world, start, end, range, new PathResult(), entity);
    }

    public AbstractPathJob(Level world, BlockPos start, BlockPos end, int range, PathResult result, LivingEntity entity) {
        int minX = Math.min(start.getX(), end.getX()) - range / 2;
        int minZ = Math.min(start.getZ(), end.getZ()) - range / 2;
        int maxX = Math.max(start.getX(), end.getX()) + range / 2;
        int maxZ = Math.max(start.getZ(), end.getZ()) + range / 2;
        this.restrictionType = AbstractAdvancedPathNavigate.RestrictionType.NONE;
        this.hardXzRestriction = false;
        this.world = new ChunkCache(world, new BlockPos(minX, world.getMinBuildHeight(), minZ), new BlockPos(maxX, world.getMaxBuildHeight(), maxZ), range, world.dimensionType());
        this.start = new BlockPos((Vec3i)start);
        this.end = end;
        this.maxRange = range;
        this.result = result;
        result.setJob(this);
        this.allowJumpPointSearchTypeWalk = false;
        if (entity != null && trackingMap.containsValue(entity.getUUID())) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<MNode>();
            this.debugNodesNotVisited = new HashSet<MNode>();
            this.debugNodesPath = new HashSet<MNode>();
        }
        this.setEntitySizes(entity);
        if (entity instanceof IPassabilityNavigator) {
            this.passabilityNavigator = (IPassabilityNavigator)entity;
            this.maxRange = this.passabilityNavigator.maxSearchNodes();
        }
        if (entity instanceof ITallWalker) {
            ITallWalker tallWalker = (ITallWalker)entity;
            this.maxNavigableGroundDist = tallWalker.getMaxNavigableDistanceToGround();
        }
        this.maxJumpHeight = (float)Math.floor(entity.maxUpStep() - 0.2f) + 1.3f;
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    public AbstractPathJob(Level world, BlockPos start, BlockPos startRestriction, BlockPos endRestriction, int range, boolean hardRestriction, PathResult result, LivingEntity entity, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        this(world, start, startRestriction, endRestriction, range, Vec3i.ZERO, hardRestriction, result, entity, restrictionType);
        this.setEntitySizes(entity);
        if (entity instanceof IPassabilityNavigator) {
            this.passabilityNavigator = (IPassabilityNavigator)entity;
            this.maxRange = this.passabilityNavigator.maxSearchNodes();
        }
        this.maxJumpHeight = (float)Math.floor(entity.maxUpStep() - 0.2f) + 1.3f;
    }

    public AbstractPathJob(Level world, BlockPos start, BlockPos startRestriction, BlockPos endRestriction, int range, Vec3i grow, boolean hardRestriction, PathResult result, LivingEntity entity, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        this.minX = Math.min(startRestriction.getX(), endRestriction.getX()) - grow.getX();
        this.minZ = Math.min(startRestriction.getZ(), endRestriction.getZ()) - grow.getZ();
        this.maxX = Math.max(startRestriction.getX(), endRestriction.getX()) + grow.getX();
        this.maxZ = Math.max(startRestriction.getZ(), endRestriction.getZ()) + grow.getZ();
        this.minY = Math.min(startRestriction.getY(), endRestriction.getY()) - grow.getY();
        this.maxY = Math.max(startRestriction.getY(), endRestriction.getY()) + grow.getY();
        this.restrictionType = restrictionType;
        this.hardXzRestriction = hardRestriction;
        this.world = new ChunkCache(world, new BlockPos(this.minX, world.getMinBuildHeight(), this.minZ), new BlockPos(this.maxX, world.getMaxBuildHeight(), this.maxZ), range, world.dimensionType());
        this.start = start;
        this.maxRange = range;
        this.result = result;
        result.setJob(this);
        this.allowJumpPointSearchTypeWalk = false;
        if (entity != null && trackingMap.containsValue(entity.getUUID())) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<MNode>();
            this.debugNodesNotVisited = new HashSet<MNode>();
            this.debugNodesPath = new HashSet<MNode>();
        }
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    public static void synchToClient(HashSet<BlockPos> reached, Mob mob) {
        if (!Pathfinding.isDebug() || reached.isEmpty()) {
            return;
        }
        for (Map.Entry<Player, UUID> entry : trackingMap.entrySet()) {
            if (!entry.getValue().equals(mob.getUUID())) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)entry.getKey()), (CustomPacketPayload)new SyncPathReachedMessage(reached), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static BlockPos prepareStart(LivingEntity entity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(entity.getBlockX(), entity.getBlockY(), entity.getBlockZ());
        Level world = entity.level();
        BlockState bs = world.getBlockState((BlockPos)pos);
        VoxelShape collisionShape = bs.getBlockSupportShape((BlockGetter)world, (BlockPos)pos);
        if (bs.blocksMotion() && collisionShape.max(Direction.Axis.X) > 0.0) {
            double relPosX = Math.abs(entity.getX() % 1.0);
            double relPosZ = Math.abs(entity.getZ() % 1.0);
            for (AABB box : collisionShape.toAabbs()) {
                if (!(relPosX >= box.minX) || !(relPosX <= box.maxX) || !(relPosZ >= box.minZ) || !(relPosZ <= box.maxZ) || !(box.maxY > 0.0)) continue;
                pos.set(pos.getX(), pos.getY() + 1, pos.getZ());
                bs = world.getBlockState((BlockPos)pos);
                break;
            }
        }
        BlockState down = world.getBlockState(pos.below());
        while (!bs.blocksMotion() && !down.blocksMotion() && !down.getBlock().isLadder(down, (LevelReader)world, pos.below(), entity) && bs.getFluidState().isEmpty()) {
            pos.move(Direction.DOWN, 1);
            bs = down;
            down = world.getBlockState(pos.below());
            if (pos.getY() >= world.getMinBuildHeight()) continue;
            return entity.blockPosition();
        }
        Block b = bs.getBlock();
        if (entity.isInWater()) {
            while (!bs.getFluidState().isEmpty()) {
                pos.set(pos.getX(), pos.getY() + 1, pos.getZ());
                bs = world.getBlockState((BlockPos)pos);
            }
        } else if (b instanceof FenceBlock || b instanceof WallBlock || bs.isSolid()) {
            double dX = entity.getX() - Math.floor(entity.getX());
            double dZ = entity.getZ() - Math.floor(entity.getZ());
            if (dX < 0.25) {
                pos.set(pos.getX() - 1, pos.getY(), pos.getZ());
            } else if (dX > 0.75) {
                pos.set(pos.getX() + 1, pos.getY(), pos.getZ());
            }
            if (dZ < 0.25) {
                pos.set(pos.getX(), pos.getY(), pos.getZ() - 1);
            } else if (dZ > 0.75) {
                pos.set(pos.getX(), pos.getY(), pos.getZ() + 1);
            }
        }
        return pos.immutable();
    }

    private static void setLadderFacing(LevelReader world, BlockPos pos, PathPointExtended p) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof VineBlock) {
            if (((Boolean)state.getValue((Property)VineBlock.SOUTH)).booleanValue()) {
                p.setLadderFacing(Direction.NORTH);
            } else if (((Boolean)state.getValue((Property)VineBlock.WEST)).booleanValue()) {
                p.setLadderFacing(Direction.EAST);
            } else if (((Boolean)state.getValue((Property)VineBlock.NORTH)).booleanValue()) {
                p.setLadderFacing(Direction.SOUTH);
            } else if (((Boolean)state.getValue((Property)VineBlock.EAST)).booleanValue()) {
                p.setLadderFacing(Direction.WEST);
            }
        } else if (block instanceof LadderBlock) {
            p.setLadderFacing((Direction)state.getValue((Property)LadderBlock.FACING));
        } else {
            p.setLadderFacing(Direction.UP);
        }
    }

    private static boolean onALadder(MNode node, @Nullable MNode nextInPath, BlockPos pos) {
        return nextInPath != null && node.isLadder() && nextInPath.pos.getX() == pos.getX() && nextInPath.pos.getZ() == pos.getZ();
    }

    private static int computeNodeKey(BlockPos pos) {
        return (pos.getX() & 0xFFF) << 20 | (pos.getY() & 0xFF) << 12 | pos.getZ() & 0xFFF;
    }

    private static boolean nodeClosed(@Nullable MNode node) {
        return node != null && node.isClosed();
    }

    private static boolean calculateSwimming(LevelReader world, BlockPos pos, @Nullable MNode node) {
        return node == null ? SurfaceType.isWater(world, pos.below()) : node.isSwimming();
    }

    public static Direction getXZFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.subtract((Vec3i)pos);
        return Direction.getNearest((float)vector.getX(), (float)0.0f, (float)vector.getZ());
    }

    public void synchToClient(LivingEntity mob) {
        Iterator<Map.Entry<Player, UUID>> iter = trackingMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Player, UUID> entry = iter.next();
            if (entry.getKey().isRemoved()) {
                iter.remove();
                continue;
            }
            if (!entry.getValue().equals(mob.getUUID())) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)entry.getKey()), (CustomPacketPayload)new SyncePathMessage(this.debugNodesVisited, this.debugNodesNotVisited, this.debugNodesPath), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected boolean onLadderGoingUp(MNode currentNode, BlockPos dPos) {
        return currentNode.isLadder() && (dPos.getY() >= 0 || dPos.getX() != 0 || dPos.getZ() != 0);
    }

    public void setEntitySizes(LivingEntity entity) {
        if (entity instanceof ICustomSizeNavigator) {
            this.entitySizeXZStart = -((int)((ICustomSizeNavigator)entity).getXZNavSize());
            this.entitySizeXZEnd = (int)((ICustomSizeNavigator)entity).getXZNavSize();
            this.entitySizeY = ((ICustomSizeNavigator)entity).getYNavSize();
        } else {
            float bbWidth = entity.getBbWidth();
            if (bbWidth <= 1.0f) {
                this.entitySizeXZStart = 0;
                this.entitySizeXZEnd = 1;
            } else {
                this.entitySizeXZStart = -((int)Math.floor(entity.getBbWidth() / 2.0f));
                this.entitySizeXZEnd = (int)Math.floor(entity.getBbWidth() / 2.0f);
            }
            this.entitySizeY = Mth.ceil((float)entity.getBbHeight());
        }
        this.allowJumpPointSearchTypeWalk = false;
    }

    protected double computeCost(BlockPos dPos, boolean isSwimming, boolean onPath, boolean onRails, boolean railsExit, boolean swimStart, boolean corner, BlockState state, BlockPos blockPos) {
        double cost = Math.sqrt(dPos.getX() * dPos.getX() + dPos.getY() * dPos.getY() + dPos.getZ() * dPos.getZ());
        if (!(dPos.getY() == 0 || Math.abs(dPos.getY()) <= 1 && this.world.getBlockState(blockPos).getBlock() instanceof StairBlock)) {
            cost = dPos.getY() > 0 ? (cost *= this.pathingOptions.jumpCost * (double)Math.abs(dPos.getY())) : (cost *= this.pathingOptions.dropCost * (double)Math.abs(dPos.getY()));
        }
        if (this.world.getBlockState(blockPos).hasProperty((Property)BlockStateProperties.OPEN)) {
            cost *= this.pathingOptions.traverseToggleAbleCost;
        }
        if (onPath) {
            cost *= this.pathingOptions.onPathCost;
        }
        if (onRails) {
            cost *= this.pathingOptions.onRailCost;
        }
        if (railsExit) {
            cost *= this.pathingOptions.railsExitCost;
        }
        if (state.getBlock() instanceof VineBlock) {
            cost *= this.pathingOptions.vineCost;
        }
        if (isSwimming) {
            cost = swimStart ? (cost *= this.pathingOptions.swimCostEnter) : (cost *= this.pathingOptions.swimCost);
        }
        return cost;
    }

    public PathResult getResult() {
        return this.result;
    }

    @Override
    public final Path call() {
        try {
            return this.search();
        }
        catch (Exception e) {
            Citadel.LOGGER.warn("Pathfinding Exception", (Throwable)e);
            return null;
        }
    }

    protected Path search() {
        MNode bestNode = this.getAndSetupStartNode();
        double bestNodeResultScore = Double.MAX_VALUE;
        while (!this.nodesOpen.isEmpty()) {
            boolean isViablePosition;
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            MNode currentNode = this.nodesOpen.poll();
            ++this.totalNodesVisited;
            if (this.totalNodesVisited > PathfindingConstants.maxPathingNodes || this.totalNodesVisited > this.maxRange * this.maxRange) break;
            currentNode.setCounterVisited(this.totalNodesVisited);
            this.handleDebugOptions(currentNode);
            currentNode.setClosed();
            boolean bl = isViablePosition = this.isInRestrictedArea(currentNode.pos) && SurfaceType.getSurfaceType((BlockGetter)this.world, this.world.getBlockState(currentNode.pos.below()), currentNode.pos.below()) == SurfaceType.WALKABLE;
            if (isViablePosition && this.isAtDestination(currentNode)) {
                bestNode = currentNode;
                this.result.setPathReachesDestination(true);
                break;
            }
            double nodeResultScore = this.getNodeResultScore(currentNode);
            if (isViablePosition && nodeResultScore < bestNodeResultScore && !currentNode.isCornerNode()) {
                bestNode = currentNode;
                bestNodeResultScore = nodeResultScore;
            }
            if (this.hardXzRestriction && !isViablePosition) continue;
            this.walkCurrentNode(currentNode);
        }
        return this.finalizePath(bestNode);
    }

    private void handleDebugOptions(MNode currentNode) {
        if (this.debugDrawEnabled) {
            this.addNodeToDebug(currentNode);
        }
        if (Pathfinding.isDebug()) {
            Citadel.LOGGER.info(String.format("Examining MNode [%d,%d,%d] ; g=%f ; f=%f", currentNode.pos.getX(), currentNode.pos.getY(), currentNode.pos.getZ(), currentNode.getCost(), currentNode.getScore()));
        }
    }

    private void addNodeToDebug(MNode currentNode) {
        this.debugNodesNotVisited.remove(currentNode);
        this.debugNodesVisited.add(currentNode);
    }

    private void addPathNodeToDebug(MNode node) {
        this.debugNodesVisited.remove(node);
        this.debugNodesPath.add(node);
    }

    private void walkCurrentNode(MNode currentNode) {
        BlockPos dPos = PathfindingConstants.BLOCKPOS_IDENTITY;
        if (currentNode.parent != null) {
            dPos = currentNode.pos.subtract((Vec3i)currentNode.parent.pos);
        }
        if (this.onLadderGoingUp(currentNode, dPos)) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_UP);
        }
        if (this.onLadderGoingDown(currentNode, dPos)) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_DOWN);
        }
        if (this.pathingOptions.canClimb()) {
            if ((Integer)this.getHighest(currentNode).getFirst() > 1) {
                this.walk(currentNode, PathfindingConstants.BLOCKPOS_IDENTITY.above(((Integer)this.getHighest(currentNode).getFirst()).intValue()));
            }
            if (currentNode.parent != null && dPos.getX() == 0 && dPos.getZ() == 0 && dPos.getY() > 1 && this.getHighest(currentNode.parent).getSecond() != null) {
                this.walk(currentNode, (BlockPos)this.getHighest(currentNode.parent).getSecond());
            }
        }
        if ((currentNode.parent == null || !currentNode.parent.pos.equals((Object)currentNode.pos.below())) && currentNode.isCornerNode()) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_DOWN);
            return;
        }
        if (this.isPassable(currentNode.pos.below(), currentNode.parent) && !currentNode.isSwimming() && this.isLiquid(this.world.getBlockState(currentNode.pos.below()))) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_DOWN);
        }
        if (dPos.getZ() <= 0) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_NORTH);
        }
        if (dPos.getX() >= 0) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_EAST);
        }
        if (dPos.getZ() >= 0) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_SOUTH);
        }
        if (dPos.getX() <= 0) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_WEST);
        }
    }

    private boolean onLadderGoingDown(MNode currentNode, BlockPos dPos) {
        return (dPos.getY() <= 0 || dPos.getX() != 0 || dPos.getZ() != 0) && this.isLadder(currentNode.pos.below());
    }

    private MNode getAndSetupStartNode() {
        MNode startNode = new MNode(this.start, this.computeHeuristic(this.start));
        if (this.pathingOptions.isFlying() && this.start.closerThan((Vec3i)this.end, (double)this.maxRange)) {
            startNode = new MNode(this.end, this.computeHeuristic(this.end));
        }
        if (this.isLadder(this.start)) {
            startNode.setLadder();
        } else if (this.isLiquid(this.world.getBlockState(this.start.below()))) {
            startNode.setSwimming();
        }
        startNode.setOnRails(this.pathingOptions.canUseRails() && this.world.getBlockState(this.start).getBlock() instanceof BaseRailBlock);
        this.nodesOpen.offer(startNode);
        this.nodesVisited.put(AbstractPathJob.computeNodeKey(this.start), startNode);
        ++this.totalNodesAdded;
        return startNode;
    }

    public boolean isLiquid(BlockState state) {
        return state.liquid() || !state.blocksMotion() && !state.getFluidState().isEmpty();
    }

    private Path finalizePath(MNode targetNode) {
        int pathLength = 1;
        int railsLength = 0;
        MNode node = targetNode;
        while (node.parent != null) {
            ++pathLength;
            if (node.isOnRails()) {
                ++railsLength;
            }
            node = node.parent;
        }
        Node[] points = new Node[pathLength];
        points[0] = new PathPointExtended(node.pos);
        if (this.debugDrawEnabled) {
            this.addPathNodeToDebug(node);
        }
        MNode nextInPath = null;
        PathPointExtended next = null;
        node = targetNode;
        while (node.parent != null) {
            if (this.debugDrawEnabled) {
                this.addPathNodeToDebug(node);
            }
            --pathLength;
            BlockPos pos = node.pos;
            if (node.isSwimming()) {
                pos.offset((Vec3i)PathfindingConstants.BLOCKPOS_DOWN);
            }
            PathPointExtended p = new PathPointExtended(pos);
            if (railsLength >= 8) {
                PathPointExtended point;
                p.setOnRails(node.isOnRails());
                if (p.isOnRails() && (!node.parent.isOnRails() || node.parent.parent == null)) {
                    p.setRailsEntry();
                } else if (p.isOnRails() && points.length > pathLength + 1 && !(point = (PathPointExtended)points[pathLength + 1]).isOnRails()) {
                    point.setRailsExit();
                }
            }
            if (AbstractPathJob.onALadder(node, nextInPath, pos)) {
                p.setOnLadder(true);
                if (nextInPath.pos.getY() > pos.getY()) {
                    AbstractPathJob.setLadderFacing(this.world, pos, p);
                }
            } else if (AbstractPathJob.onALadder(node.parent, node.parent, pos)) {
                p.setOnLadder(true);
            }
            if (next != null) {
                next.cameFrom = p;
            }
            next = p;
            points[pathLength] = p;
            nextInPath = node;
            node = node.parent;
        }
        this.doDebugPrinting(points);
        return new Path(Arrays.asList(points), this.getPathTargetPos(targetNode), this.isAtDestination(targetNode));
    }

    protected BlockPos getPathTargetPos(MNode finalNode) {
        return finalNode.pos;
    }

    private void doDebugPrinting(Node[] points) {
        if (Pathfinding.isDebug()) {
            Citadel.LOGGER.info("Path found:");
            for (Node p : points) {
                Citadel.LOGGER.info("Step: [{},{},{}]", (Object)p.x, (Object)p.y, (Object)p.z);
            }
            Citadel.LOGGER.info("Total Nodes Visited {} / {}", (Object)this.totalNodesVisited, (Object)this.totalNodesAdded);
        }
    }

    protected abstract double computeHeuristic(BlockPos var1);

    protected abstract boolean isAtDestination(MNode var1);

    protected abstract double getNodeResultScore(MNode var1);

    protected final boolean walk(MNode parent, BlockPos dPos) {
        int nodeKey;
        MNode node;
        BlockPos pos = parent.pos.offset((Vec3i)dPos);
        int newY = this.getGroundHeight(parent, pos);
        if (newY < this.world.getMinBuildHeight()) {
            return false;
        }
        boolean corner = false;
        if (pos.getY() != newY) {
            if (!(parent.isCornerNode() || newY - pos.getY() <= 0 || parent.parent != null && parent.parent.pos.equals((Object)parent.pos.offset((Vec3i)new BlockPos(0, newY - pos.getY(), 0))))) {
                dPos = new BlockPos(0, newY - pos.getY(), 0);
                pos = parent.pos.offset((Vec3i)dPos);
                corner = true;
            } else if (!(parent.isCornerNode() || newY - pos.getY() >= 0 || dPos.getX() == 0 && dPos.getZ() == 0 || parent.parent != null && parent.pos.below().equals((Object)parent.parent.pos))) {
                dPos = new BlockPos(dPos.getX(), 0, dPos.getZ());
                pos = parent.pos.offset((Vec3i)dPos);
                corner = true;
            } else if (!this.pathingOptions.canClimb() || dPos.getY() <= 1) {
                dPos = dPos.offset(0, newY - pos.getY(), 0);
                pos = new BlockPos(pos.getX(), newY, pos.getZ());
            }
        }
        if (AbstractPathJob.nodeClosed(node = this.nodesVisited.get(nodeKey = AbstractPathJob.computeNodeKey(pos)))) {
            return false;
        }
        boolean isSwimming = AbstractPathJob.calculateSwimming(this.world, pos, node);
        if (isSwimming && !this.pathingOptions.canSwim()) {
            return false;
        }
        boolean swimStart = isSwimming && !parent.isSwimming();
        BlockState state = this.world.getBlockState(pos);
        boolean onRoad = false;
        boolean onRails = this.pathingOptions.canUseRails() && this.world.getBlockState(corner ? pos.below() : pos).getBlock() instanceof BaseRailBlock;
        boolean railsExit = !onRails && parent.isOnRails();
        double stepCost = this.computeCost(dPos, isSwimming, false, onRails, railsExit, swimStart, corner, state, pos);
        double heuristic = this.computeHeuristic(pos);
        double cost = parent.getCost() + stepCost;
        double score = cost + heuristic;
        if (node == null) {
            node = this.createNode(parent, pos, nodeKey, isSwimming, heuristic, cost, score);
            node.setOnRails(onRails);
            node.setCornerNode(corner);
        } else if (this.updateCurrentNode(parent, node, heuristic, cost, score)) {
            return false;
        }
        this.nodesOpen.offer(node);
        if (this.pathingOptions.canClimb() && dPos.getY() > 1) {
            return true;
        }
        this.performJumpPointSearch(parent, dPos, node);
        return true;
    }

    private void performJumpPointSearch(MNode parent, BlockPos dPos, MNode node) {
        if (this.allowJumpPointSearchTypeWalk && node.getHeuristic() <= parent.getHeuristic()) {
            this.walk(node, dPos);
        }
    }

    private MNode createNode(MNode parent, BlockPos pos, int nodeKey, boolean isSwimming, double heuristic, double cost, double score) {
        MNode node = new MNode(parent, pos, cost, heuristic, score);
        this.nodesVisited.put(nodeKey, node);
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.add(node);
        }
        if (this.isLadder(pos)) {
            node.setLadder();
        } else if (isSwimming) {
            node.setSwimming();
        }
        ++this.totalNodesAdded;
        node.setCounterAdded(this.totalNodesAdded);
        return node;
    }

    private boolean updateCurrentNode(MNode parent, MNode node, double heuristic, double cost, double score) {
        if (score >= node.getScore()) {
            return true;
        }
        if (!this.nodesOpen.remove(node)) {
            return true;
        }
        node.parent = parent;
        node.setSteps(parent.getSteps() + 1);
        node.setCost(cost);
        node.setHeuristic(heuristic);
        node.setScore(score);
        return false;
    }

    protected int getGroundHeight(MNode parent, BlockPos pos) {
        if (this.checkHeadBlock(parent, pos)) {
            return this.handleTargetNotPassable(parent, pos.above(), this.world.getBlockState(pos.above()));
        }
        BlockState target = this.world.getBlockState(pos);
        if (parent != null && !this.isPassableBB(parent.pos, pos, parent)) {
            return this.handleTargetNotPassable(parent, pos, target);
        }
        int i = 0;
        BlockState below = null;
        SurfaceType lastSurfaceType = null;
        while (i < this.maxNavigableGroundDist) {
            below = this.world.getBlockState(pos.below(++i));
            if (!(this.pathingOptions.isFlying() ? (lastSurfaceType = this.isFlyable(below, pos, parent)) == SurfaceType.FLYABLE : (lastSurfaceType = this.isWalkableSurface(below, pos)) == SurfaceType.WALKABLE)) continue;
            return pos.getY();
        }
        return lastSurfaceType != SurfaceType.NOT_PASSABLE && below != null ? this.handleNotStanding(parent, pos, below) : -1;
    }

    private int handleNotStanding(@Nullable MNode parent, BlockPos pos, BlockState below) {
        boolean isSwimming;
        boolean bl = isSwimming = parent != null && parent.isSwimming();
        if (this.isLiquid(below)) {
            return this.handleInLiquid(pos, below, isSwimming);
        }
        if (this.isLadder(below.getBlock(), pos.below())) {
            return pos.getY();
        }
        return this.checkDrop(parent, pos, isSwimming);
    }

    private int checkDrop(@Nullable MNode parent, BlockPos pos, boolean isSwimming) {
        boolean canDrop = parent != null && !parent.isLadder();
        boolean isChonker = true;
        if (this.pathingOptions.canClimb() && parent != null && pos.getY() > parent.pos.getY() + 1) {
            return pos.getY();
        }
        if (!isChonker && (!canDrop || isSwimming || (parent.pos.getX() != pos.getX() || parent.pos.getZ() != pos.getZ()) && this.isPassableBBFull(parent.pos.below(), parent) && this.isWalkableSurface(this.world.getBlockState(parent.pos.below()), parent.pos.below()) == SurfaceType.DROPABLE)) {
            return -1;
        }
        for (int i = 2; i <= 10; ++i) {
            BlockState below = this.world.getBlockState(pos.below(i));
            if (this.isWalkableSurface(below, pos) == SurfaceType.WALKABLE && i <= 4 || below.liquid()) {
                return pos.getY() - i + 1;
            }
            if (!below.isAir()) continue;
            return -1;
        }
        return -1;
    }

    private int handleInLiquid(BlockPos pos, BlockState below, boolean isSwimming) {
        if (isSwimming) {
            return pos.getY();
        }
        if (this.pathingOptions.canSwim() && SurfaceType.isWater(this.world, pos.below())) {
            return pos.getY();
        }
        return -1;
    }

    private int handleTargetNotPassable(@Nullable MNode parent, BlockPos pos, BlockState target) {
        VoxelShape bb2;
        VoxelShape bb1;
        boolean canJump;
        boolean bl = canJump = parent != null && !parent.isLadder() && !parent.isSwimming();
        if (!canJump || SurfaceType.getSurfaceType((BlockGetter)this.world, target, pos) != SurfaceType.WALKABLE) {
            return -1;
        }
        if (!this.isPassable(pos.above(2), parent)) {
            bb1 = this.world.getBlockState(pos).getBlockSupportShape((BlockGetter)this.world, pos);
            bb2 = this.world.getBlockState(pos.above(2)).getBlockSupportShape((BlockGetter)this.world, pos.above(2));
            if ((double)pos.above(2).getY() + this.getStartY(bb2, 1) - ((double)pos.getY() + this.getEndY(bb1, 0)) < 2.0) {
                return -1;
            }
        }
        if (!this.isPassable(parent.pos.above(2), parent)) {
            bb1 = this.world.getBlockState(pos).getBlockSupportShape((BlockGetter)this.world, pos);
            bb2 = this.world.getBlockState(parent.pos.above(2)).getBlockSupportShape((BlockGetter)this.world, parent.pos.above(2));
            if ((double)parent.pos.above(2).getY() + this.getStartY(bb2, 1) - ((double)pos.getY() + this.getEndY(bb1, 0)) < 2.0) {
                return -1;
            }
        }
        BlockState parentBelow = this.world.getBlockState(parent.pos.below());
        VoxelShape parentBB = parentBelow.getBlockSupportShape((BlockGetter)this.world, parent.pos.below());
        double parentY = parentBB.max(Direction.Axis.Y);
        double parentMaxY = parentY + (double)parent.pos.below().getY();
        double targetMaxY = target.getBlockSupportShape((BlockGetter)this.world, pos).max(Direction.Axis.Y) + (double)pos.getY();
        if (targetMaxY - parentMaxY < this.maxJumpHeight) {
            return pos.getY() + 1;
        }
        if (target.getBlock() instanceof StairBlock && parentY - 0.5 < this.maxJumpHeight && target.getValue((Property)StairBlock.HALF) == Half.BOTTOM && AbstractPathJob.getXZFacing(parent.pos, pos) == target.getValue((Property)StairBlock.FACING)) {
            return pos.getY() + 1;
        }
        return -1;
    }

    private Pair<Integer, BlockPos> getHighest(MNode node) {
        int max = 1;
        BlockPos pos = node.pos;
        BlockPos direction = null;
        if (this.world.getBlockState(pos.north()).canOcclude() && this.climbableTop(pos.north(), Direction.SOUTH, node) > max) {
            max = this.climbableTop(pos.north(), Direction.SOUTH, node);
            direction = PathfindingConstants.BLOCKPOS_NORTH;
        }
        if (this.world.getBlockState(pos.east()).canOcclude() && this.climbableTop(pos.east(), Direction.WEST, node) > max) {
            max = this.climbableTop(pos.east(), Direction.WEST, node);
            direction = PathfindingConstants.BLOCKPOS_EAST;
        }
        if (this.world.getBlockState(pos.south()).canOcclude() && this.climbableTop(pos.south(), Direction.NORTH, node) > max) {
            max = this.climbableTop(pos.south(), Direction.NORTH, node);
            direction = PathfindingConstants.BLOCKPOS_SOUTH;
        }
        if (this.world.getBlockState(pos.west()).canOcclude() && this.climbableTop(pos.west(), Direction.EAST, node) > max) {
            max = this.climbableTop(pos.west(), Direction.EAST, node);
            direction = PathfindingConstants.BLOCKPOS_WEST;
        }
        return new Pair((Object)max, (Object)direction);
    }

    private int climbableTop(BlockPos pos, Direction direction, MNode node) {
        BlockState target = this.world.getBlockState(pos);
        int i = 0;
        while (target.canOcclude()) {
            pos = pos.above();
            target = this.world.getBlockState(pos);
            BlockState origin = this.world.getBlockState(pos.relative(direction));
            if (!this.isPassable(origin, pos.relative(direction), node)) {
                i = 0;
                break;
            }
            ++i;
        }
        return i;
    }

    private boolean checkHeadBlock(@Nullable MNode parent, BlockPos pos) {
        BlockPos localPos = pos;
        VoxelShape bb = this.world.getBlockState(localPos).getCollisionShape((BlockGetter)this.world, localPos);
        if (bb.max(Direction.Axis.Y) < 1.0) {
            localPos = pos.above();
        }
        if (parent == null || !this.isPassableBB(parent.pos, pos.above(), parent)) {
            VoxelShape bb1 = this.world.getBlockState(pos.below()).getBlockSupportShape((BlockGetter)this.world, pos.below());
            VoxelShape bb2 = this.world.getBlockState(pos.above()).getBlockSupportShape((BlockGetter)this.world, pos.above());
            if ((double)pos.above().getY() + this.getStartY(bb2, 1) - ((double)pos.below().getY() + this.getEndY(bb1, 0)) < 2.0) {
                return true;
            }
            if (parent != null) {
                VoxelShape bb3 = this.world.getBlockState(parent.pos.below()).getBlockSupportShape((BlockGetter)this.world, pos.below());
                if ((double)pos.above().getY() + this.getStartY(bb2, 1) - ((double)parent.pos.below().getY() + this.getEndY(bb3, 0)) < 1.75) {
                    return true;
                }
            }
        }
        if (parent != null) {
            BlockState hereState = this.world.getBlockState(localPos.below());
            VoxelShape bb1 = this.world.getBlockState(pos).getBlockSupportShape((BlockGetter)this.world, pos);
            VoxelShape bb2 = this.world.getBlockState(localPos.above()).getBlockSupportShape((BlockGetter)this.world, localPos.above());
            if ((double)localPos.above().getY() + this.getStartY(bb2, 1) - ((double)pos.getY() + this.getEndY(bb1, 0)) >= 2.0) {
                return false;
            }
            return this.isLiquid(hereState) && !this.isPassable(pos, parent);
        }
        return false;
    }

    private double getStartY(VoxelShape bb, int def) {
        return bb.isEmpty() ? (double)def : bb.min(Direction.Axis.Y);
    }

    private double getEndY(VoxelShape bb, int def) {
        return bb.isEmpty() ? (double)def : bb.max(Direction.Axis.Y);
    }

    protected boolean isPassable(BlockState block, BlockPos pos, MNode parent) {
        Direction facing;
        Direction direction;
        BlockPos dir;
        BlockPos parentPos = parent == null ? this.start : parent.pos;
        BlockState parentBlock = this.world.getBlockState(parentPos);
        if (parentBlock.getBlock() instanceof TrapDoorBlock && ((dir = pos.subtract((Vec3i)parentPos)).getX() != 0 || dir.getZ() != 0) && (direction = AbstractPathJob.getXZFacing(parentPos, pos)) == (facing = (Direction)parentBlock.getValue((Property)TrapDoorBlock.FACING)).getOpposite()) {
            return false;
        }
        if (!block.isAir()) {
            VoxelShape shape = block.getBlockSupportShape((BlockGetter)this.world, pos);
            if (block.blocksMotion() && !shape.isEmpty() && !(shape.max(Direction.Axis.Y) <= 0.1)) {
                if (block.getBlock() instanceof TrapDoorBlock) {
                    Direction facing2;
                    BlockPos dir2 = pos.subtract((Vec3i)parentPos);
                    if (dir2.getY() != 0 && dir2.getX() == 0 && dir2.getZ() == 0) {
                        return true;
                    }
                    Direction direction2 = AbstractPathJob.getXZFacing(parentPos, pos);
                    if (direction2 == (facing2 = (Direction)block.getValue((Property)TrapDoorBlock.FACING)).getOpposite()) {
                        return true;
                    }
                    return direction2 != facing2;
                }
                return this.pathingOptions.canEnterDoors() && (block.getBlock() instanceof DoorBlock || block.getBlock() instanceof FenceGateBlock) || block.getBlock() instanceof PressurePlateBlock || block.getBlock() instanceof SignBlock || block.getBlock() instanceof AbstractBannerBlock;
            }
            if (block.getBlock() instanceof FireBlock || block.getBlock() instanceof SweetBerryBushBlock) {
                return false;
            }
            if (this.isLadder(block.getBlock(), pos)) {
                return true;
            }
            if (shape.isEmpty() || shape.max(Direction.Axis.Y) <= 0.125 && !this.isLiquid(block) && (block.getBlock() != Blocks.SNOW || (Integer)block.getValue((Property)SnowLayerBlock.LAYERS) == 1)) {
                PathType pathType = block.getBlockPathType((BlockGetter)this.world, pos, null);
                return pathType == null;
            }
            return false;
        }
        return true;
    }

    protected boolean isPassable(BlockPos pos, MNode parent) {
        BlockState state = this.world.getBlockState(pos);
        VoxelShape shape = state.getBlockSupportShape((BlockGetter)this.world, pos);
        if (this.passabilityNavigator != null && this.passabilityNavigator.isBlockExplicitlyNotPassable(state, pos, pos)) {
            return false;
        }
        if (shape.isEmpty() || shape.max(Direction.Axis.Y) <= 0.1) {
            if (this.passabilityNavigator != null && this.passabilityNavigator.isBlockExplicitlyPassable(state, pos, pos)) {
                return this.isPassable(state, pos, parent);
            }
            return true;
        }
        return this.isPassable(state, pos, parent);
    }

    protected boolean isPassableBBFull(BlockPos pos, MNode parent) {
        for (int i = this.entitySizeXZStart; i <= this.entitySizeXZEnd; ++i) {
            for (int j = 0; j < this.entitySizeY; ++j) {
                for (int k = this.entitySizeXZStart; k <= this.entitySizeXZEnd; ++k) {
                    if (this.isPassable(pos.offset(i, j, k), parent)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isPassableBB(BlockPos parentPos, BlockPos pos, MNode parent) {
        Direction facingDir = AbstractPathJob.getXZFacing(parentPos, pos);
        if (facingDir == Direction.DOWN || facingDir == Direction.UP) {
            return false;
        }
        facingDir = facingDir.getClockWise();
        for (int i = this.entitySizeXZStart; i <= this.entitySizeXZEnd; ++i) {
            for (int j = 0; j < this.entitySizeY; ++j) {
                if (this.isPassable(pos.relative(facingDir, i).above(j), parent)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isPassableBBDown(BlockPos parentPos, BlockPos pos, MNode parent) {
        Direction facingDir = AbstractPathJob.getXZFacing(parentPos, pos);
        if (facingDir == Direction.DOWN || facingDir == Direction.UP) {
            return false;
        }
        facingDir = facingDir.getClockWise();
        for (int i = this.entitySizeXZStart; i <= this.entitySizeXZEnd; ++i) {
            for (int j = 0; j < this.entitySizeY; ++j) {
                if (this.isPassable(pos.relative(facingDir, i).above(j), parent) && pos.getY() > parentPos.getY()) continue;
                return false;
            }
        }
        return true;
    }

    protected SurfaceType isFlyable(BlockState blockState, BlockPos pos, MNode parent) {
        Block block = blockState.getBlock();
        if (block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock || block instanceof FireBlock || block instanceof CampfireBlock || block instanceof BambooStalkBlock || block instanceof BambooSaplingBlock || blockState.getShape((BlockGetter)this.world, pos).max(Direction.Axis.Y) > 1.0) {
            return SurfaceType.NOT_PASSABLE;
        }
        FluidState fluid = this.world.getFluidState(pos);
        if (!(fluid.isEmpty() || fluid.getType() != Fluids.LAVA && fluid.getType() != Fluids.FLOWING_LAVA)) {
            return SurfaceType.NOT_PASSABLE;
        }
        if (this.isPassable(blockState, pos, parent)) {
            return SurfaceType.FLYABLE;
        }
        return SurfaceType.DROPABLE;
    }

    protected SurfaceType isWalkableSurface(BlockState blockState, BlockPos pos) {
        Block block = blockState.getBlock();
        if (block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock || block instanceof FireBlock || block instanceof CampfireBlock || block instanceof BambooStalkBlock || block instanceof BambooSaplingBlock || blockState.getShape((BlockGetter)this.world, pos).max(Direction.Axis.Y) > 1.0) {
            return SurfaceType.NOT_PASSABLE;
        }
        FluidState fluid = this.world.getFluidState(pos);
        if (!(fluid.isEmpty() || fluid.getType() != Fluids.LAVA && fluid.getType() != Fluids.FLOWING_LAVA)) {
            return SurfaceType.NOT_PASSABLE;
        }
        if (block instanceof SignBlock) {
            return SurfaceType.DROPABLE;
        }
        if (blockState.isSolid() || blockState.getBlock() == Blocks.SNOW && (Integer)blockState.getValue((Property)SnowLayerBlock.LAYERS) > 1 || block instanceof WoolCarpetBlock) {
            return SurfaceType.WALKABLE;
        }
        return SurfaceType.DROPABLE;
    }

    protected boolean isLadder(Block block, BlockPos pos) {
        return block.isLadder(this.world.getBlockState(pos), this.world, pos, (LivingEntity)this.entity.get());
    }

    protected boolean isLadder(BlockPos pos) {
        return this.isLadder(this.world.getBlockState(pos).getBlock(), pos);
    }

    public void setPathingOptions(PathingOptions pathingOptions) {
        this.pathingOptions = pathingOptions;
    }

    public boolean isInRestrictedArea(BlockPos pos) {
        boolean isInXZ;
        if (this.restrictionType == AbstractAdvancedPathNavigate.RestrictionType.NONE) {
            return true;
        }
        boolean bl = isInXZ = pos.getX() <= this.maxX && pos.getZ() <= this.maxZ && pos.getZ() >= this.minZ && pos.getX() >= this.minX;
        if (!isInXZ) {
            return false;
        }
        if (this.restrictionType == AbstractAdvancedPathNavigate.RestrictionType.XZ) {
            return true;
        }
        return pos.getY() <= this.maxY && pos.getY() >= this.minY;
    }
}

