/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.block.CitadelLecternBlock;
import com.github.alexthe666.citadel.server.block.CitadelLecternBlockEntity;
import com.github.alexthe666.citadel.server.block.LecternBooks;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.tick.ServerTickRateTracker;
import com.github.alexthe666.citadel.server.world.CitadelServerData;
import com.github.alexthe666.citadel.server.world.ModifiableTickRateServer;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class CitadelEvents {
    private int updateTimer;

    @SubscribeEvent
    public void onEntityUpdateDebug(EntityTickEvent.Post event) {
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().getBlockState(event.getPos()).is(Blocks.LECTERN) && LecternBooks.isLecternBook(event.getItemStack())) {
            LecternBlockEntity oldBe;
            event.getEntity().getCooldowns().addCooldown(event.getItemStack().getItem(), 1);
            BlockState oldLectern = event.getLevel().getBlockState(event.getPos());
            BlockEntity blockEntity = event.getLevel().getBlockEntity(event.getPos());
            if (blockEntity instanceof LecternBlockEntity && !(oldBe = (LecternBlockEntity)blockEntity).hasBook()) {
                BlockState newLectern = (BlockState)((BlockState)((BlockState)Citadel.LECTERN.get().defaultBlockState().setValue((Property)CitadelLecternBlock.FACING, (Comparable)((Direction)oldLectern.getValue((Property)LecternBlock.FACING)))).setValue((Property)CitadelLecternBlock.POWERED, (Comparable)((Boolean)oldLectern.getValue((Property)LecternBlock.POWERED)))).setValue((Property)CitadelLecternBlock.HAS_BOOK, (Comparable)Boolean.valueOf(true));
                event.getLevel().setBlockAndUpdate(event.getPos(), newLectern);
                CitadelLecternBlockEntity newBe = new CitadelLecternBlockEntity(event.getPos(), newLectern);
                ItemStack bookCopy = event.getItemStack().copy();
                bookCopy.setCount(1);
                newBe.setBook(bookCopy);
                if (!event.getEntity().isCreative()) {
                    event.getItemStack().shrink(1);
                }
                event.getLevel().setBlockEntity((BlockEntity)newBe);
                event.getEntity().swing(event.getHand(), true);
                event.getLevel().playSound(null, event.getPos(), SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (CitadelEntityData.getCitadelTag((LivingEntity)event.getOriginal()) != null) {
            CitadelEntityData.setCitadelTag((LivingEntity)event.getEntity(), CitadelEntityData.getCitadelTag((LivingEntity)event.getOriginal()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onServerTick(ServerTickEvent.Pre event) {
        if (event.getServer().isRunning()) {
            ServerTickRateTracker tickRateTracker = CitadelServerData.get(event.getServer()).getOrCreateTickRateTracker();
            MinecraftServer minecraftServer = event.getServer();
            if (minecraftServer instanceof ModifiableTickRateServer) {
                ModifiableTickRateServer modifiableServer = (ModifiableTickRateServer)minecraftServer;
                long l = tickRateTracker.getServerTickLengthMs();
                if (l == 50L) {
                    modifiableServer.resetGlobalTickLengthMs();
                } else {
                    modifiableServer.setGlobalTickLengthMs(tickRateTracker.getServerTickLengthMs());
                }
                if (!event.getServer().isShutdown()) {
                    tickRateTracker.masterTick();
                }
            }
        }
    }
}

