/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.mixin;

import com.github.alexthe666.citadel.server.event.EventMergeStructureSpawns;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkGenerator.class})
public class ChunkGeneratorMixin {
    @Inject(at={@At(value="RETURN")}, remap=true, cancellable=true, method={"getMobsAt(Lnet/minecraft/core/Holder;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/util/random/WeightedRandomList;"})
    private void citadel_getMobsAt(Holder<Biome> biome, StructureManager structureManager, MobCategory mobCategory, BlockPos pos, CallbackInfoReturnable<WeightedRandomList<MobSpawnSettings.SpawnerData>> cir) {
        WeightedRandomList biomeSpawns = ((Biome)biome.value()).getMobSettings().getMobs(mobCategory);
        if (biomeSpawns != cir.getReturnValue()) {
            EventMergeStructureSpawns event = new EventMergeStructureSpawns(structureManager, pos, mobCategory, (WeightedRandomList<MobSpawnSettings.SpawnerData>)((WeightedRandomList)cir.getReturnValue()), (WeightedRandomList<MobSpawnSettings.SpawnerData>)biomeSpawns);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.getResult() == TriState.TRUE) {
                cir.setReturnValue(event.getStructureSpawns());
            }
        }
    }
}

