/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.render.pathfinding;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.client.render.pathfinding.WorldEventContext;
import com.github.alexthe666.citadel.client.render.pathfinding.WorldRenderMacros;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.MNode;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PathfindingDebugRenderer {
    public static final RenderBuffers renderBuffers = new RenderBuffers(Runtime.getRuntime().availableProcessors());
    private static final MultiBufferSource.BufferSource renderBuffer = renderBuffers.bufferSource();
    public static Set<MNode> lastDebugNodesVisited = new HashSet<MNode>();
    public static Set<MNode> lastDebugNodesNotVisited = new HashSet<MNode>();
    public static Set<MNode> lastDebugNodesPath = new HashSet<MNode>();

    public static void render(WorldEventContext ctx) {
        try {
            for (MNode n : lastDebugNodesVisited) {
                PathfindingDebugRenderer.debugDrawNode(n, -65536, ctx);
            }
            for (MNode n : lastDebugNodesNotVisited) {
                PathfindingDebugRenderer.debugDrawNode(n, -16776961, ctx);
            }
            for (MNode n : lastDebugNodesPath) {
                if (n.isReachedByWorker()) {
                    PathfindingDebugRenderer.debugDrawNode(n, -39424, ctx);
                    continue;
                }
                PathfindingDebugRenderer.debugDrawNode(n, -16711936, ctx);
            }
        }
        catch (ConcurrentModificationException exc) {
            Citadel.LOGGER.catching((Throwable)exc);
        }
    }

    private static void debugDrawNode(MNode n, int argbColor, WorldEventContext ctx) {
        ctx.poseStack.pushPose();
        ctx.poseStack.translate((double)n.pos.getX() + 0.375, (double)n.pos.getY() + 0.375, (double)n.pos.getZ() + 0.375);
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if (n.pos.closerThan((Vec3i)entity.blockPosition(), 5.0)) {
            PathfindingDebugRenderer.renderDebugText(n, ctx);
        }
        ctx.poseStack.scale(0.25f, 0.25f, 0.25f);
        WorldRenderMacros.renderBox(ctx.bufferSource, ctx.poseStack, BlockPos.ZERO, BlockPos.ZERO, argbColor);
        if (n.parent != null) {
            Matrix4f lineMatrix = ctx.poseStack.last().pose();
            float pdx = (float)(n.parent.pos.getX() - n.pos.getX()) + 0.125f;
            float pdy = (float)(n.parent.pos.getY() - n.pos.getY()) + 0.125f;
            float pdz = (float)(n.parent.pos.getZ() - n.pos.getZ()) + 0.125f;
            VertexConsumer buffer = ctx.bufferSource.getBuffer(WorldRenderMacros.LINES);
            buffer.addVertex(lineMatrix, 0.5f, 0.5f, 0.5f).setColor(0.75f, 0.75f, 0.75f, 1.0f);
            buffer.addVertex(lineMatrix, pdx / 0.25f, pdy / 0.25f, pdz / 0.25f).setColor(0.75f, 0.75f, 0.75f, 1.0f);
        }
        ctx.poseStack.popPose();
    }

    private static void renderDebugText(@NotNull MNode n, WorldEventContext ctx) {
        Font fontrenderer = Minecraft.getInstance().font;
        String s1 = String.format("F: %.3f [%d]", n.getCost(), n.getCounterAdded());
        String s2 = String.format("G: %.3f [%d]", n.getScore(), n.getCounterVisited());
        int i = Math.max(fontrenderer.width(s1), fontrenderer.width(s2)) / 2;
        ctx.poseStack.pushPose();
        ctx.poseStack.translate(0.0f, 0.75f, 0.0f);
        ctx.poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        ctx.poseStack.scale(-0.014f, -0.014f, 0.014f);
        ctx.poseStack.translate(0.0f, 18.0f, 0.0f);
        Matrix4f mat = ctx.poseStack.last().pose();
        WorldRenderMacros.renderFillRectangle(ctx.bufferSource, ctx.poseStack, -i - 1, -5, 0, 2 * i + 2, 17, 0x7F000000);
        ctx.poseStack.translate(0.0f, -5.0f, -0.1f);
        fontrenderer.drawInBatch(s1, (float)(-fontrenderer.width(s1)) / 2.0f, 1.0f, -1, false, mat, (MultiBufferSource)ctx.bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        ctx.poseStack.translate(0.0f, 8.0f, -0.1f);
        fontrenderer.drawInBatch(s2, (float)(-fontrenderer.width(s2)) / 2.0f, 1.0f, -1, false, mat, (MultiBufferSource)ctx.bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        ctx.poseStack.popPose();
    }
}

