/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.render;

import com.github.alexthe666.citadel.server.block.CitadelLecternBlockEntity;
import com.github.alexthe666.citadel.server.block.LecternBooks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CitadelLecternRenderer
implements BlockEntityRenderer<CitadelLecternBlockEntity> {
    private final BookModel bookModel;
    public static final ResourceLocation BOOK_PAGE_TEXTURE = ResourceLocation.parse((String)"citadel:textures/entity/lectern_book_pages.png");
    public static final ResourceLocation BOOK_BINDING_TEXTURE = ResourceLocation.parse((String)"citadel:textures/entity/lectern_book_binding.png");
    private static final LecternBooks.BookData EMPTY_BOOK_DATA = new LecternBooks.BookData(12944441, 16050623);

    public CitadelLecternRenderer(BlockEntityRendererProvider.Context context) {
        this.bookModel = new BookModel(context.bakeLayer(ModelLayers.BOOK));
    }

    public void render(CitadelLecternBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int i, int j) {
        BlockState blockstate = blockEntity.getBlockState();
        if (((Boolean)blockstate.getValue((Property)LecternBlock.HAS_BOOK)).booleanValue()) {
            LecternBooks.BookData bookData = LecternBooks.BOOKS.getOrDefault(BuiltInRegistries.ITEM.getKey((Object)blockEntity.getBook().getItem()), EMPTY_BOOK_DATA);
            poseStack.pushPose();
            poseStack.translate(0.5, 1.0625, 0.5);
            float f = ((Direction)blockstate.getValue((Property)LecternBlock.FACING)).getClockWise().toYRot();
            poseStack.mulPose(Axis.YP.rotationDegrees(-f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(67.5f));
            poseStack.translate(0.0, -0.125, 0.0);
            this.bookModel.setupAnim(0.0f, 0.1f, 0.9f, 1.2f);
            VertexConsumer pages = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)BOOK_PAGE_TEXTURE));
            this.bookModel.render(poseStack, pages, i, j, bookData.getPageColor());
            VertexConsumer binding = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)BOOK_BINDING_TEXTURE));
            this.bookModel.render(poseStack, binding, i, j, bookData.getBindingColor());
            poseStack.popPose();
        }
    }
}

