/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.gui;

import com.github.alexthe666.citadel.ClientProxy;
import com.github.alexthe666.citadel.client.rewards.CitadelCapes;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class GuiCitadelCapesConfig
extends OptionsSubScreen {
    @Nullable
    private String capeType;
    private Button button;

    public GuiCitadelCapesConfig(Screen parentScreenIn, Options gameSettingsIn) {
        super(parentScreenIn, gameSettingsIn, (Component)Component.translatable((String)"citadel.gui.capes"));
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.getInstance().player);
        this.capeType = tag.contains("CitadelCapeType") && !tag.getString("CitadelCapeType").isEmpty() ? tag.getString("CitadelCapeType") : null;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int i = this.width / 2;
        int j = this.height / 6;
        guiGraphics.pose().pushPose();
        ClientProxy.hideFollower = true;
        GuiCitadelCapesConfig.renderBackwardsEntity(i, j + 144, 60, 0.0f, 0.0f, (LivingEntity)Minecraft.getInstance().player);
        ClientProxy.hideFollower = false;
        guiGraphics.pose().popPose();
    }

    public static void renderBackwardsEntity(int x, int y, int size, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        matrix4fStack.translate((float)x, (float)y, 1050.0f);
        matrix4fStack.scale(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        posestack1.translate(0.0, 0.0, 1000.0);
        posestack1.scale((float)size, (float)size, (float)size);
        Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
        Quaternionf quaternion1 = Axis.XP.rotationDegrees(angleYComponent * 20.0f);
        quaternion.mul((Quaternionfc)quaternion1);
        quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        posestack1.mulPose(quaternion);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        quaternion1.conjugate();
        entityrenderdispatcher.overrideCameraOrientation(quaternion1);
        entityrenderdispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0));
        multibuffersource$buffersource.endBatch();
        entityrenderdispatcher.setRenderShadow(true);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
        matrix4fStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
    }

    protected void init() {
        super.init();
        int i = this.width / 2;
        int j = this.height / 6;
        Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, p_213079_1_ -> this.minecraft.setScreen(this.lastScreen)).size(200, 20).pos(i - 100, j + 160).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
        this.button = Button.builder((Component)this.getTypeText(), p_213079_1_ -> {
            CitadelCapes.Cape nextCape = CitadelCapes.getNextCape(this.capeType, Minecraft.getInstance().player.getUUID());
            this.capeType = nextCape == null ? null : nextCape.getIdentifier();
            CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.getInstance().player);
            if (this.capeType == null) {
                tag.putString("CitadelCapeType", "");
                tag.putBoolean("CitadelCapeDisabled", true);
            } else {
                tag.putString("CitadelCapeType", this.capeType);
                tag.putBoolean("CitadelCapeDisabled", false);
            }
            CitadelEntityData.setCitadelTag((LivingEntity)Minecraft.getInstance().player, tag);
            PacketDistributor.sendToServer((CustomPacketPayload)new PropertiesMessage("CitadelTagUpdate", tag, Minecraft.getInstance().player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.button.setMessage(this.getTypeText());
        }).size(200, 20).pos(i - 100, j).build();
        this.addRenderableWidget((GuiEventListener)this.button);
    }

    protected void addOptions() {
    }

    private Component getTypeText() {
        CitadelCapes.Cape cape;
        MutableComponent suffix = this.capeType == null ? Component.translatable((String)"citadel.gui.no_cape") : ((cape = CitadelCapes.getById(this.capeType)) == null ? Component.translatable((String)"citadel.gui.no_cape") : Component.translatable((String)("cape." + cape.getIdentifier())));
        return Component.translatable((String)"citadel.gui.cape_type").append(" ").append((Component)suffix);
    }
}

