/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.item.CitadelDataComponents;
import com.github.alexthe666.citadel.item.data.FancyItemDisplay;
import com.github.alexthe666.citadel.item.data.IconItemDisplay;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix4f;

public class CitadelItemstackRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation DEFAULT_ICON_TEXTURE = ResourceLocation.parse((String)"citadel:textures/gui/book/icon_default.png");
    private static final Map<String, ResourceLocation> LOADED_ICONS = new HashMap<String, ResourceLocation>();
    private static List<Holder.Reference<MobEffect>> mobEffectList = null;

    public CitadelItemstackRenderer() {
        super(null, null);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        int id;
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
        float ticksExisted = (float)Util.getMillis() / 50.0f + partialTicks;
        int n = id = Minecraft.getInstance().player == null ? 0 : Minecraft.getInstance().player.getId();
        if (stack.getItem() == Citadel.FANCY_ITEM.get()) {
            Random random = new Random();
            boolean animateAnyways = false;
            ItemStack toRender = null;
            FancyItemDisplay display = (FancyItemDisplay)stack.get((DataComponentType)CitadelDataComponents.FANCY_ITEM_DISPLAY.get());
            if (display != null && !display.displayItem().isEmpty()) {
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)display.displayItem()));
                toRender = new ItemStack((ItemLike)item);
            }
            if (toRender == null || toRender.isEmpty()) {
                animateAnyways = true;
                toRender = new ItemStack((ItemLike)Items.BARRIER);
            }
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            if (display != null && display.displayShake()) {
                poseStack.translate((random.nextFloat() - 0.5f) * 0.1f, (random.nextFloat() - 0.5f) * 0.1f, (random.nextFloat() - 0.5f) * 0.1f);
            }
            if (animateAnyways || display != null && display.displayBob()) {
                poseStack.translate(0.0f, 0.05f + 0.1f * Mth.sin((float)(0.3f * ticksExisted)), 0.0f);
            }
            if (display != null && display.displaySpin()) {
                poseStack.mulPose(Axis.YP.rotationDegrees(6.0f * ticksExisted));
            }
            if (animateAnyways || display != null && display.displayZoom()) {
                float scale = (float)(1.0 + (double)0.15f * (Math.sin(ticksExisted * 0.3f) + 1.0));
                poseStack.scale(scale, scale, scale);
            }
            if (display != null && display.displayScale() != 1.0f) {
                float scale = display.displayScale();
                poseStack.scale(scale, scale, scale);
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(toRender, displayContext, packedLight, packedOverlay, poseStack, buffer, null, id);
            poseStack.popPose();
        }
        if (stack.getItem() == Citadel.EFFECT_ITEM.get()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            if (mobEffectList == null) {
                mobEffectList = BuiltInRegistries.MOB_EFFECT.holders().toList();
            }
            int size = mobEffectList.size();
            int time = (int)(Util.getMillis() / 500L);
            Holder effect = (Holder)mobEffectList.get(time % size);
            if (effect == null) {
                effect = MobEffects.MOVEMENT_SPEED.getDelegate();
            }
            MobEffectTextureManager potionspriteuploader = Minecraft.getInstance().getMobEffectTextures();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 0.5f);
            TextureAtlasSprite sprite = potionspriteuploader.get(effect);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
            BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            Matrix4f mx = poseStack.last().pose();
            int br = 255;
            bufferbuilder.addVertex(mx, 1.0f, 1.0f, 0.0f).setUv(sprite.getU1(), sprite.getV0()).setColor(br, br, br, 255).setLight(packedLight);
            bufferbuilder.addVertex(mx, 0.0f, 1.0f, 0.0f).setUv(sprite.getU0(), sprite.getV0()).setColor(br, br, br, 255).setLight(packedLight);
            bufferbuilder.addVertex(mx, 0.0f, 0.0f, 0.0f).setUv(sprite.getU0(), sprite.getV1()).setColor(br, br, br, 255).setLight(packedLight);
            bufferbuilder.addVertex(mx, 1.0f, 0.0f, 0.0f).setUv(sprite.getU1(), sprite.getV1()).setColor(br, br, br, 255).setLight(packedLight);
            poseStack.popPose();
        }
        if (stack.getItem() == Citadel.ICON_ITEM.get()) {
            ResourceLocation texture = DEFAULT_ICON_TEXTURE;
            IconItemDisplay display = (IconItemDisplay)stack.get((DataComponentType)CitadelDataComponents.ICON_ITEM_DISPLAY.get());
            if (display != null && !display.iconLocation().isEmpty()) {
                String iconLocationStr = display.iconLocation();
                if (LOADED_ICONS.containsKey(iconLocationStr)) {
                    texture = LOADED_ICONS.get(iconLocationStr);
                } else {
                    texture = ResourceLocation.parse((String)iconLocationStr);
                    LOADED_ICONS.put(iconLocationStr, texture);
                }
            }
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 0.5f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            Tesselator tessellator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            Matrix4f mx = poseStack.last().pose();
            int br = 255;
            bufferbuilder.addVertex(mx, 1.0f, 1.0f, 0.0f).setUv(1.0f, 0.0f).setColor(br, br, br, 255).setLight(packedLight);
            bufferbuilder.addVertex(mx, 0.0f, 1.0f, 0.0f).setUv(0.0f, 0.0f).setColor(br, br, br, 255).setLight(packedLight);
            bufferbuilder.addVertex(mx, 0.0f, 0.0f, 0.0f).setUv(0.0f, 1.0f).setColor(br, br, br, 255).setLight(packedLight);
            bufferbuilder.addVertex(mx, 1.0f, 0.0f, 0.0f).setUv(1.0f, 1.0f).setColor(br, br, br, 255).setLight(packedLight);
            poseStack.popPose();
        }
    }
}

