/*
 * Decompiled with CFR 0.152.
 */
package com.jopgood.cfwinfo.common.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CommonConfig {
    public static final CommonConfig INSTANCE;
    public static final ModConfigSpec SPEC;
    public final ModConfigSpec.BooleanValue infoEnabled;
    public final ModConfigSpec.BooleanValue simplifiedEnabled;
    public final ModConfigSpec.BooleanValue messagesEnabled;
    public final ModConfigSpec.IntValue overlayOpacity;
    public final ModConfigSpec.EnumValue<OverlayPosition> overlayPosition;
    public final ModConfigSpec.DoubleValue spriteScaleFactor;

    private CommonConfig(ModConfigSpec.Builder builder) {
        builder.push("overlay");
        this.infoEnabled = builder.comment("Enable or disable the fuel and water information overlay").translation("cfwinfo.config.info_enabled").define("info_enabled", true);
        this.simplifiedEnabled = builder.comment("Show a simplified version of the overlay without requiring goggles").translation("cfwinfo.config.simplified_enabled").define("simplified_enabled", false);
        this.overlayOpacity = builder.comment("Opacity of the overlay (0-100)").translation("cfwinfo.config.overlay_opacity").defineInRange("overlay_opacity", 80, 0, 100);
        this.overlayPosition = builder.comment("Position of the overlay on screen").translation("cfwinfo.config.overlay_position").defineEnum("overlay_position", (Enum)OverlayPosition.TOP_LEFT);
        this.spriteScaleFactor = builder.comment("Scale factor for tank overlay size (1.0 = normal size, 2.0 = double size)").translation("cfwinfo.config.sprite_scale_factor").defineInRange("sprite_scale_factor", 2.0, 0.5, 5.0);
        this.messagesEnabled = builder.comment("Show notification messages when changing settings").translation("cfwinfo.config.messages_enabled").define("messages_enabled", false);
        builder.pop();
    }

    public static boolean isInfoEnabled() {
        return (Boolean)CommonConfig.INSTANCE.infoEnabled.get();
    }

    public static void enableInfo(Boolean enable) {
        CommonConfig.INSTANCE.infoEnabled.set((Object)enable);
    }

    public static boolean isSimplifiedEnabled() {
        return (Boolean)CommonConfig.INSTANCE.simplifiedEnabled.get();
    }

    public static void enableSimplified(Boolean enable) {
        CommonConfig.INSTANCE.simplifiedEnabled.set((Object)enable);
    }

    public static boolean isMessagesEnabled() {
        return (Boolean)CommonConfig.INSTANCE.messagesEnabled.get();
    }

    public static int getOverlayOpacity() {
        return (Integer)CommonConfig.INSTANCE.overlayOpacity.get();
    }

    public static OverlayPosition getOverlayPosition() {
        return (OverlayPosition)((Object)CommonConfig.INSTANCE.overlayPosition.get());
    }

    public static double getSpriteScaleFactor() {
        return (Double)CommonConfig.INSTANCE.spriteScaleFactor.get();
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        INSTANCE = (CommonConfig)pair.getLeft();
        SPEC = (ModConfigSpec)pair.getRight();
    }

    public static enum OverlayPosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

