/*
 * Decompiled with CFR 0.152.
 */
package com.jopgood.cfwinfo.client.gui;

import com.jopgood.cfwinfo.client.gui.TankGuiHelper;
import com.jopgood.cfwinfo.common.config.CommonConfig;
import com.jopgood.cfwinfo.common.data.TankDataManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TankSpriteOverlay
implements LayeredDraw.Layer {
    private static final ResourceLocation SPRITE = ResourceLocation.fromNamespaceAndPath((String)"cfwinfo", (String)"textures/gui/sprites/tank_sprite_sheet.png");
    private static final int FRAME_WIDTH = 15;
    private static final int FRAME_HEIGHT = 32;
    private static final int FRAMES_PER_ROW = 18;
    private static final int TOTAL_FRAMES = 18;
    private static final int SPRITE_SHEET_WIDTH = 270;
    private static final int SPRITE_SHEET_HEIGHT = 96;
    private static final int MAX_LEVEL = 1600;

    public void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        boolean renderEnabled = CommonConfig.isInfoEnabled();
        boolean simpleEnabled = CommonConfig.isSimplifiedEnabled();
        boolean wearingTank = TankGuiHelper.canDisplayTankInfo();
        if (!renderEnabled || !simpleEnabled) {
            return;
        }
        if (!wearingTank) {
            return;
        }
        this.renderTankSprites(graphics, (Player)player);
    }

    private void renderTankSprites(GuiGraphics graphics, Player player) {
        boolean toolIsTank;
        int x;
        ItemStack tankItem = player.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack toolItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        int fuelLevel = (int)Math.round(TankDataManager.getFuelLevel(tankItem));
        int waterLevel = (int)Math.round(TankDataManager.getWaterLevel(tankItem));
        int fuelFrameIndex = (1600 - fuelLevel) * 17 / 1600;
        int waterFrameIndex = (1600 - waterLevel) * 17 / 1600;
        fuelFrameIndex = Math.max(0, Math.min(17, fuelFrameIndex));
        waterFrameIndex = Math.max(0, Math.min(17, waterFrameIndex));
        int fuelU = fuelFrameIndex % 18 * 15;
        int fuelV = 0;
        int waterU = waterFrameIndex % 18 * 15;
        int waterV = 32;
        int tankU = 0;
        int tankV = 64;
        float scaleFactor = (float)CommonConfig.getSpriteScaleFactor();
        int renderWidth = (int)(15.0f * scaleFactor);
        int renderHeight = (int)(32.0f * scaleFactor);
        CommonConfig.OverlayPosition position = CommonConfig.getOverlayPosition();
        int y = switch (position) {
            case CommonConfig.OverlayPosition.TOP_LEFT -> {
                x = 10;
                yield 10;
            }
            case CommonConfig.OverlayPosition.TOP_RIGHT -> {
                x = graphics.guiWidth() - renderWidth - 10;
                yield 10;
            }
            case CommonConfig.OverlayPosition.BOTTOM_LEFT -> {
                x = 10;
                yield graphics.guiHeight() - renderHeight - 10;
            }
            case CommonConfig.OverlayPosition.BOTTOM_RIGHT -> {
                x = graphics.guiWidth() - renderWidth - 10;
                yield graphics.guiHeight() - renderHeight - 10;
            }
            default -> {
                x = graphics.guiWidth() / 2 - renderWidth / 2;
                yield graphics.guiHeight() / 2 - renderHeight / 2;
            }
        };
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SPRITE);
        float opacity = (float)CommonConfig.getOverlayOpacity() / 100.0f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        graphics.pose().pushPose();
        graphics.pose().scale(scaleFactor, scaleFactor, 1.0f);
        int scaledX = (int)((float)x / scaleFactor);
        int scaledY = (int)((float)y / scaleFactor);
        boolean bl = toolIsTank = TankDataManager.isHoldingFuelCapableItem(player) || TankDataManager.isHoldingWaterCapableItem(player);
        if (toolIsTank) {
            this.renderDualTankDisplay(graphics, scaledX, scaledY, tankItem, toolItem, tankU, tankV, fuelU, fuelV, waterU, waterV, position);
        } else {
            this.renderSingleTankDisplay(graphics, scaledX, scaledY, tankItem, toolItem, tankU, tankV, fuelU, fuelV, waterU, waterV, position);
        }
        graphics.pose().popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderDualTankDisplay(GuiGraphics graphics, int scaledX, int scaledY, ItemStack tankItem, ItemStack toolItem, int tankU, int tankV, int fuelU, int fuelV, int waterU, int waterV, CommonConfig.OverlayPosition position) {
        int item2X;
        int item1X;
        int tank2X;
        int tank1X;
        int toolFuelLevel = (int)Math.round(TankDataManager.getFuelLevel(toolItem));
        int toolWaterLevel = (int)Math.round(TankDataManager.getWaterLevel(toolItem));
        int toolFuelFrameIndex = (1600 - toolFuelLevel) * 17 / 1600;
        int toolWaterFrameIndex = (1600 - toolWaterLevel) * 17 / 1600;
        toolFuelFrameIndex = Math.max(0, Math.min(17, toolFuelFrameIndex));
        toolWaterFrameIndex = Math.max(0, Math.min(17, toolWaterFrameIndex));
        int toolFuelU = toolFuelFrameIndex % 18 * 15;
        int toolWaterU = toolWaterFrameIndex % 18 * 15;
        boolean toolTankOnLeft = position == CommonConfig.OverlayPosition.TOP_RIGHT || position == CommonConfig.OverlayPosition.BOTTOM_RIGHT;
        boolean itemsAbove = position == CommonConfig.OverlayPosition.BOTTOM_LEFT || position == CommonConfig.OverlayPosition.BOTTOM_RIGHT;
        boolean isRightSide = position == CommonConfig.OverlayPosition.TOP_RIGHT || position == CommonConfig.OverlayPosition.BOTTOM_RIGHT;
        float scaleFactor = (float)CommonConfig.getSpriteScaleFactor();
        int paddingOffset = isRightSide ? (int)(16.0f / scaleFactor) : 0;
        int adjustedX = scaledX - paddingOffset;
        if (toolTankOnLeft) {
            tank1X = adjustedX + 15;
            tank2X = adjustedX;
            item1X = adjustedX + 15;
            item2X = adjustedX;
        } else {
            tank1X = adjustedX;
            tank2X = adjustedX + 15;
            item1X = adjustedX;
            item2X = adjustedX + 15;
        }
        int itemY = itemsAbove ? scaledY - 16 : scaledY + 32;
        this.renderTankLayers(graphics, tank1X, scaledY, tankU, tankV, fuelU, fuelV, waterU, waterV);
        this.renderTankLayers(graphics, tank2X, scaledY, tankU, tankV, toolFuelU, fuelV, toolWaterU, waterV);
        GuiGameElement.of((ItemStack)tankItem).at((float)item1X, (float)itemY, 450.0f).render(graphics);
        GuiGameElement.of((ItemStack)toolItem).at((float)item2X, (float)itemY, 450.0f).render(graphics);
    }

    private void renderSingleTankDisplay(GuiGraphics graphics, int scaledX, int scaledY, ItemStack tankItem, ItemStack toolItem, int tankU, int tankV, int fuelU, int fuelV, int waterU, int waterV, CommonConfig.OverlayPosition position) {
        boolean isRightSide = position == CommonConfig.OverlayPosition.TOP_RIGHT || position == CommonConfig.OverlayPosition.BOTTOM_RIGHT;
        float scaleFactor = (float)CommonConfig.getSpriteScaleFactor();
        int paddingOffset = isRightSide ? (int)(16.0f / scaleFactor) : 0;
        int adjustedX = scaledX - paddingOffset;
        this.renderTankLayers(graphics, adjustedX, scaledY, tankU, tankV, fuelU, fuelV, waterU, waterV);
        boolean itemsAbove = position == CommonConfig.OverlayPosition.BOTTOM_LEFT || position == CommonConfig.OverlayPosition.BOTTOM_RIGHT;
        int itemY = itemsAbove ? scaledY - 16 : scaledY + 32;
        GuiGameElement.of((ItemStack)tankItem).at((float)adjustedX, (float)itemY, 450.0f).render(graphics);
        if (!toolItem.isEmpty()) {
            GuiGameElement.of((ItemStack)toolItem).at((float)(adjustedX + 16), (float)itemY, 450.0f).render(graphics);
        }
    }

    private void renderTankLayers(GuiGraphics graphics, int scaledX, int scaledY, int tankU, int tankV, int fuelU, int fuelV, int waterU, int waterV) {
        graphics.blit(SPRITE, scaledX, scaledY, (float)tankU, (float)tankV, 15, 32, 270, 96);
        graphics.blit(SPRITE, scaledX, scaledY, (float)fuelU, (float)fuelV, 15, 32, 270, 96);
        graphics.blit(SPRITE, scaledX, scaledY, (float)waterU, (float)waterV, 15, 32, 270, 96);
    }
}

