/*
 * Decompiled with CFR 0.152.
 */
package com.jopgood.cfwinfo.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class PositionedTooltipRenderer {
    public static void renderTooltip(GuiGraphics graphics, List<Component> tooltip, int x, int y, int backgroundColor, int borderTop, int borderBot) {
        PositionedTooltipRenderer.renderTooltip(graphics, tooltip, x, y, backgroundColor, borderTop, borderBot, 8, 8, 8, 8);
    }

    public static void renderTooltip(GuiGraphics graphics, List<Component> tooltip, int x, int y, int backgroundColor, int borderTop, int borderBot, int paddingTop, int paddingBottom, int paddingLeft, int paddingRight) {
        if (tooltip.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : tooltip) {
            int textLineWidth = mc.font.width(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        int n = x - paddingLeft;
        int bgY1 = y - paddingTop;
        int bgX2 = x + tooltipTextWidth + paddingRight;
        int bgY2 = y + tooltipHeight + paddingBottom;
        int zLevel = 400;
        graphics.fillGradient(n, bgY1, bgX2, bgY1 + 1, zLevel, backgroundColor, backgroundColor);
        graphics.fillGradient(n, bgY2 - 1, bgX2, bgY2, zLevel, backgroundColor, backgroundColor);
        graphics.fillGradient(n, bgY1 + 1, bgX2, bgY2 - 1, zLevel, backgroundColor, backgroundColor);
        graphics.fillGradient(n - 1, bgY1 + 1, n, bgY2 - 1, zLevel, backgroundColor, backgroundColor);
        graphics.fillGradient(bgX2, bgY1 + 1, bgX2 + 1, bgY2 - 1, zLevel, backgroundColor, backgroundColor);
        graphics.fillGradient(n, bgY1, bgX2, bgY1 + 1, zLevel, borderTop, borderTop);
        graphics.fillGradient(n, bgY2 - 1, bgX2, bgY2, zLevel, borderBot, borderBot);
        graphics.fillGradient(n - 1, bgY1 + 1, n, bgY2 - 1, zLevel, borderTop, borderBot);
        graphics.fillGradient(bgX2, bgY1 + 1, bgX2 + 1, bgY2 - 1, zLevel, borderTop, borderBot);
        poseStack.translate(0.0, 0.0, (double)zLevel);
        int textY = y;
        boolean isFirstLine = true;
        for (Component line : tooltip) {
            if (isFirstLine) {
                graphics.drawString(mc.font, line, x, textY, -1, false);
                isFirstLine = false;
                textY += 12;
                continue;
            }
            graphics.drawString(mc.font, line, x, textY, -1, false);
            textY += 10;
        }
        poseStack.popPose();
    }
}

