/*
 * Decompiled with CFR 0.152.
 */
package com.jopgood.cfwinfo.client;

import com.jopgood.cfwinfo.client.KeyBinding;
import com.jopgood.cfwinfo.client.gui.TankSpriteOverlay;
import com.jopgood.cfwinfo.client.gui.TankTooltipOverlay;
import com.jopgood.cfwinfo.common.config.CommonConfig;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

@Mod(value="cfwinfo", dist={Dist.CLIENT})
@EventBusSubscriber(modid="cfwinfo", value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)KeyBinding.TOGGLE_OVERLAY.get());
        event.register((KeyMapping)KeyBinding.TOGGLE_SIMPLIFIED.get());
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        boolean messages = CommonConfig.isMessagesEnabled();
        while (((KeyMapping)KeyBinding.TOGGLE_OVERLAY.get()).consumeClick()) {
            boolean visible = CommonConfig.isInfoEnabled();
            CommonConfig.enableInfo(!visible);
            if (!(mc.player != null & messages)) continue;
            mc.player.sendSystemMessage((Component)Component.literal((String)("Overlay: " + (!visible ? "Shown" : "Hidden"))));
        }
        while (((KeyMapping)KeyBinding.TOGGLE_SIMPLIFIED.get()).consumeClick()) {
            boolean simple = CommonConfig.isSimplifiedEnabled();
            CommonConfig.enableSimplified(!simple);
            if (!(mc.player != null & messages)) continue;
            mc.player.sendSystemMessage((Component)Component.literal((String)("Simplified Mode: " + (!simple ? "On" : "Off"))));
        }
    }

    @SubscribeEvent
    public static void onRegisterGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"cfwinfo", (String)"tank_tooltip_overlay"), (LayeredDraw.Layer)new TankTooltipOverlay());
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"cfwinfo", (String)"tank_sprite_overlay"), (LayeredDraw.Layer)new TankSpriteOverlay());
    }
}

