/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.typesafe.config.impl;

import de.bluecolored.shadow.typesafe.config.ConfigException;
import de.bluecolored.shadow.typesafe.config.impl.AbstractConfigNodeValue;
import de.bluecolored.shadow.typesafe.config.impl.AbstractConfigValue;
import de.bluecolored.shadow.typesafe.config.impl.ConfigReference;
import de.bluecolored.shadow.typesafe.config.impl.ConfigString;
import de.bluecolored.shadow.typesafe.config.impl.Path;
import de.bluecolored.shadow.typesafe.config.impl.PathParser;
import de.bluecolored.shadow.typesafe.config.impl.SubstitutionExpression;
import de.bluecolored.shadow.typesafe.config.impl.Token;
import de.bluecolored.shadow.typesafe.config.impl.Tokens;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class ConfigNodeSimpleValue
extends AbstractConfigNodeValue {
    final Token token;

    ConfigNodeSimpleValue(Token value) {
        this.token = value;
    }

    @Override
    protected Collection<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    protected Token token() {
        return this.token;
    }

    protected AbstractConfigValue value() {
        if (Tokens.isValue(this.token)) {
            return Tokens.getValue(this.token);
        }
        if (Tokens.isUnquotedText(this.token)) {
            return new ConfigString.Unquoted(this.token.origin(), Tokens.getUnquotedText(this.token));
        }
        if (Tokens.isSubstitution(this.token)) {
            List<Token> expression = Tokens.getSubstitutionPathExpression(this.token);
            Path path = PathParser.parsePathExpression(expression.iterator(), this.token.origin());
            boolean optional = Tokens.getSubstitutionOptional(this.token);
            return new ConfigReference(this.token.origin(), new SubstitutionExpression(path, optional));
        }
        throw new ConfigException.BugOrBroken("ConfigNodeSimpleValue did not contain a valid value token");
    }
}

