/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.configurate.util;

import de.bluecolored.shadow.configurate.util.NamingScheme;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum NamingSchemes implements NamingScheme
{
    PASSTHROUGH{

        @Override
        public String coerce(String input) {
            return input;
        }
    }
    ,
    CAMEL_CASE{

        @Override
        public String coerce(String input) {
            Matcher match = DASH_UNDERSCORE.matcher(input);
            if (!match.find()) {
                return input;
            }
            StringBuffer ret = new StringBuffer(input.length());
            do {
                match.appendReplacement(ret, "");
                ret.appendCodePoint(input.codePointAt(match.start()));
                ret.appendCodePoint(Character.toUpperCase(input.codePointBefore(match.end())));
            } while (match.find());
            match.appendTail(ret);
            return ret.toString();
        }
    }
    ,
    SNAKE_CASE{

        @Override
        public String coerce(String input) {
            return NamingSchemes.enforceLowerCaseSeparatorChar(input, '_', '-');
        }
    }
    ,
    LOWER_CASE_DASHED{

        @Override
        public String coerce(String input) {
            return NamingSchemes.enforceLowerCaseSeparatorChar(input, '-', '_');
        }
    };

    private static final Pattern DASH_UNDERSCORE;
    private static final char UNDERSCORE = '_';
    private static final char DASH = '-';

    private static String enforceLowerCaseSeparatorChar(String input, char preferredDelimiter, char convertDelimiter) {
        StringBuilder build = new StringBuilder(input);
        for (int i = 0; i < build.length(); ++i) {
            int ch = build.codePointAt(i);
            if (ch == convertDelimiter) {
                if (i == 0 || i == build.length() - 1) continue;
                build.setCharAt(i, preferredDelimiter);
                continue;
            }
            if (!Character.isUpperCase(ch)) continue;
            build.insert(i++, preferredDelimiter);
            int lower = Character.toLowerCase(ch);
            if (Character.isBmpCodePoint(lower)) {
                build.setCharAt(i, (char)lower);
                continue;
            }
            build.setCharAt(i++, Character.highSurrogate(lower));
            build.setCharAt(i, Character.lowSurrogate(lower));
        }
        return build.toString();
    }

    static {
        DASH_UNDERSCORE = Pattern.compile(".[-_].");
    }
}

