/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.apache.commons.dbcp2.datasources;

import de.bluecolored.shadow.apache.commons.dbcp2.datasources.InstanceKeyDataSource;
import de.bluecolored.shadow.apache.commons.dbcp2.datasources.InstanceKeyDataSourceFactory;
import de.bluecolored.shadow.apache.commons.dbcp2.datasources.PerUserPoolDataSource;
import java.io.IOException;
import java.util.Map;
import javax.naming.RefAddr;
import javax.naming.Reference;

public class PerUserPoolDataSourceFactory
extends InstanceKeyDataSourceFactory {
    private static final String PER_USER_POOL_CLASSNAME = PerUserPoolDataSource.class.getName();

    @Override
    protected InstanceKeyDataSource getNewInstance(Reference ref) throws IOException, ClassNotFoundException {
        byte[] serialized;
        PerUserPoolDataSource pupds = new PerUserPoolDataSource();
        RefAddr ra = ref.get("defaultMaxTotal");
        if (ra != null && ra.getContent() != null) {
            pupds.setDefaultMaxTotal(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("defaultMaxIdle")) != null && ra.getContent() != null) {
            pupds.setDefaultMaxIdle(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("defaultMaxWaitMillis")) != null && ra.getContent() != null) {
            pupds.setDefaultMaxWaitMillis(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("perUserDefaultAutoCommit")) != null && ra.getContent() != null) {
            serialized = (byte[])ra.getContent();
            pupds.setPerUserDefaultAutoCommit((Map)PerUserPoolDataSourceFactory.deserialize(serialized));
        }
        if ((ra = ref.get("perUserDefaultTransactionIsolation")) != null && ra.getContent() != null) {
            serialized = (byte[])ra.getContent();
            pupds.setPerUserDefaultTransactionIsolation((Map)PerUserPoolDataSourceFactory.deserialize(serialized));
        }
        if ((ra = ref.get("perUserMaxTotal")) != null && ra.getContent() != null) {
            serialized = (byte[])ra.getContent();
            pupds.setPerUserMaxTotal((Map)PerUserPoolDataSourceFactory.deserialize(serialized));
        }
        if ((ra = ref.get("perUserMaxIdle")) != null && ra.getContent() != null) {
            serialized = (byte[])ra.getContent();
            pupds.setPerUserMaxIdle((Map)PerUserPoolDataSourceFactory.deserialize(serialized));
        }
        if ((ra = ref.get("perUserMaxWaitMillis")) != null && ra.getContent() != null) {
            serialized = (byte[])ra.getContent();
            pupds.setPerUserMaxWaitMillis((Map)PerUserPoolDataSourceFactory.deserialize(serialized));
        }
        if ((ra = ref.get("perUserDefaultReadOnly")) != null && ra.getContent() != null) {
            serialized = (byte[])ra.getContent();
            pupds.setPerUserDefaultReadOnly((Map)PerUserPoolDataSourceFactory.deserialize(serialized));
        }
        return pupds;
    }

    @Override
    protected boolean isCorrectClass(String className) {
        return PER_USER_POOL_CLASSNAME.equals(className);
    }
}

