/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.apache.commons.dbcp2.datasources;

import de.bluecolored.shadow.apache.commons.dbcp2.Utils;
import de.bluecolored.shadow.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import de.bluecolored.shadow.apache.commons.dbcp2.datasources.PooledConnectionManager;
import de.bluecolored.shadow.apache.commons.dbcp2.datasources.UserPassKey;
import de.bluecolored.shadow.apache.commons.pool2.ObjectPool;
import de.bluecolored.shadow.apache.commons.pool2.PooledObject;
import de.bluecolored.shadow.apache.commons.pool2.PooledObjectFactory;
import de.bluecolored.shadow.apache.commons.pool2.impl.DefaultPooledObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

class CPDSConnectionFactory
implements PooledObjectFactory<PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource cpds;
    private final String validationQuery;
    private final int validationQueryTimeoutSeconds;
    private final boolean rollbackAfterValidation;
    private ObjectPool<PooledConnectionAndInfo> pool;
    private UserPassKey userPassKey;
    private Duration maxConnLifetime = Duration.ofMillis(-1L);
    private final Set<PooledConnection> validatingSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<PooledConnection, PooledConnectionAndInfo> pcMap = new ConcurrentHashMap<PooledConnection, PooledConnectionAndInfo>();

    public CPDSConnectionFactory(ConnectionPoolDataSource cpds, String validationQuery, int validationQueryTimeoutSeconds, boolean rollbackAfterValidation, String userName, char[] userPassword) {
        this.cpds = cpds;
        this.validationQuery = validationQuery;
        this.validationQueryTimeoutSeconds = validationQueryTimeoutSeconds;
        this.userPassKey = new UserPassKey(userName, userPassword);
        this.rollbackAfterValidation = rollbackAfterValidation;
    }

    public CPDSConnectionFactory(ConnectionPoolDataSource cpds, String validationQuery, int validationQueryTimeoutSeconds, boolean rollbackAfterValidation, String userName, String userPassword) {
        this(cpds, validationQuery, validationQueryTimeoutSeconds, rollbackAfterValidation, userName, Utils.toCharArray(userPassword));
    }

    @Override
    public void activateObject(PooledObject<PooledConnectionAndInfo> p) throws Exception {
        this.validateLifetime(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePool(String userName) throws SQLException {
        CPDSConnectionFactory cPDSConnectionFactory = this;
        synchronized (cPDSConnectionFactory) {
            if (userName == null || !userName.equals(this.userPassKey.getUserName())) {
                return;
            }
        }
        try {
            this.pool.close();
        }
        catch (Exception ex) {
            throw new SQLException("Error closing connection pool", ex);
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.validatingSet.contains(pc)) {
            PooledConnectionAndInfo pci = this.pcMap.get(pc);
            if (pci == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this.pool.returnObject(pci);
            }
            catch (Exception e) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pc.removeConnectionEventListener(this);
                try {
                    this.doDestroyObject(pci);
                }
                catch (Exception e2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pci);
                    e2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (null != event.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
        }
        pc.removeConnectionEventListener(this);
        PooledConnectionAndInfo pci = this.pcMap.get(pc);
        if (pci == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject(pci);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pci);
            e.printStackTrace();
        }
    }

    @Override
    public void destroyObject(PooledObject<PooledConnectionAndInfo> p) throws Exception {
        this.doDestroyObject(p.getObject());
    }

    private void doDestroyObject(PooledConnectionAndInfo pci) throws Exception {
        PooledConnection pc = pci.getPooledConnection();
        pc.removeConnectionEventListener(this);
        this.pcMap.remove(pc);
        pc.close();
    }

    char[] getPasswordCharArray() {
        return this.userPassKey.getPasswordCharArray();
    }

    public ObjectPool<PooledConnectionAndInfo> getPool() {
        return this.pool;
    }

    @Override
    public void invalidate(PooledConnection pc) throws SQLException {
        PooledConnectionAndInfo pci = this.pcMap.get(pc);
        if (pci == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject(pci);
            this.pool.close();
        }
        catch (Exception ex) {
            throw new SQLException("Error invalidating connection", ex);
        }
    }

    @Override
    public synchronized PooledObject<PooledConnectionAndInfo> makeObject() {
        PooledConnectionAndInfo pci;
        try {
            PooledConnection pc = null;
            pc = this.userPassKey.getUserName() == null ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(this.userPassKey.getUserName(), this.userPassKey.getPassword());
            if (pc == null) {
                throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
            }
            pc.addConnectionEventListener(this);
            pci = new PooledConnectionAndInfo(pc, this.userPassKey);
            this.pcMap.put(pc, pci);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
        return new DefaultPooledObject<PooledConnectionAndInfo>(pci);
    }

    @Override
    public void passivateObject(PooledObject<PooledConnectionAndInfo> p) throws Exception {
        this.validateLifetime(p);
    }

    public void setMaxConnLifetime(Duration maxConnLifetime) {
        this.maxConnLifetime = maxConnLifetime;
    }

    @Deprecated
    public void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.setMaxConnLifetime(Duration.ofMillis(maxConnLifetimeMillis));
    }

    public synchronized void setPassword(char[] userPassword) {
        this.userPassKey = new UserPassKey(this.userPassKey.getUserName(), userPassword);
    }

    @Override
    public synchronized void setPassword(String userPassword) {
        this.userPassKey = new UserPassKey(this.userPassKey.getUserName(), userPassword);
    }

    public void setPool(ObjectPool<PooledConnectionAndInfo> pool) {
        this.pool = pool;
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("[cpds=");
        builder.append(this.cpds);
        builder.append(", validationQuery=");
        builder.append(this.validationQuery);
        builder.append(", validationQueryTimeoutSeconds=");
        builder.append(this.validationQueryTimeoutSeconds);
        builder.append(", rollbackAfterValidation=");
        builder.append(this.rollbackAfterValidation);
        builder.append(", pool=");
        builder.append(this.pool);
        builder.append(", maxConnLifetimeMillis=");
        builder.append(this.maxConnLifetime);
        builder.append(", validatingSet=");
        builder.append(this.validatingSet);
        builder.append(", pcMap=");
        builder.append(this.pcMap);
        builder.append("]");
        return builder.toString();
    }

    private void validateLifetime(PooledObject<PooledConnectionAndInfo> pooledObject) throws Exception {
        long lifetimeMillis;
        if (this.maxConnLifetime.compareTo(Duration.ZERO) > 0 && (lifetimeMillis = System.currentTimeMillis() - pooledObject.getCreateTime()) > this.maxConnLifetime.toMillis()) {
            throw new Exception(Utils.getMessage("connectionFactory.lifetimeExceeded", lifetimeMillis, this.maxConnLifetime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateObject(PooledObject<PooledConnectionAndInfo> p) {
        try {
            this.validateLifetime(p);
        }
        catch (Exception e) {
            return false;
        }
        boolean valid = false;
        PooledConnection pconn = p.getObject().getPooledConnection();
        Connection conn = null;
        this.validatingSet.add(pconn);
        if (null == this.validationQuery) {
            int timeoutSeconds = this.validationQueryTimeoutSeconds;
            if (timeoutSeconds < 0) {
                timeoutSeconds = 0;
            }
            try {
                conn = pconn.getConnection();
                valid = conn.isValid(timeoutSeconds);
                return valid;
            }
            catch (SQLException e) {
                valid = false;
                return valid;
            }
            finally {
                Utils.closeQuietly(conn);
                this.validatingSet.remove(pconn);
            }
        }
        Statement stmt = null;
        ResultSet rset = null;
        this.validatingSet.add(pconn);
        try {
            conn = pconn.getConnection();
            stmt = conn.createStatement();
            rset = stmt.executeQuery(this.validationQuery);
            valid = rset.next();
            if (this.rollbackAfterValidation) {
                conn.rollback();
            }
            Utils.closeQuietly(rset);
        }
        catch (Exception e) {
            valid = false;
            return valid;
        }
        Utils.closeQuietly(stmt);
        Utils.closeQuietly(conn);
        this.validatingSet.remove(pconn);
        return valid;
        finally {
            Utils.closeQuietly(rset);
            Utils.closeQuietly(stmt);
            Utils.closeQuietly(conn);
            this.validatingSet.remove(pconn);
        }
    }
}

