/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.biome;

import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.biome.GrassColorModifier;
import java.util.Objects;

public interface Biome
extends Keyed {
    public static final Biome DEFAULT = new Default();

    public float getDownfall();

    public float getTemperature();

    public Color getWaterColor();

    public Color getOverlayFoliageColor();

    public Color getOverlayGrassColor();

    public GrassColorModifier getGrassColorModifier();

    public static class Default
    implements Biome {
        private final Key key = Key.bluemap("default");
        private final float downfall = 0.5f;
        private final float temperature = 0.5f;
        private final Color waterColor = new Color().set(-12618012).premultiplied();
        private final Color overlayFoliageColor = new Color().premultiplied();
        private final Color overlayGrassColor = new Color().premultiplied();
        private final GrassColorModifier grassColorModifier = GrassColorModifier.NONE;

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public float getDownfall() {
            Objects.requireNonNull(this);
            return 0.5f;
        }

        @Override
        public float getTemperature() {
            Objects.requireNonNull(this);
            return 0.5f;
        }

        @Override
        public Color getWaterColor() {
            return this.waterColor;
        }

        @Override
        public Color getOverlayFoliageColor() {
            return this.overlayFoliageColor;
        }

        @Override
        public Color getOverlayGrassColor() {
            return this.overlayGrassColor;
        }

        @Override
        public GrassColorModifier getGrassColorModifier() {
            return this.grassColorModifier;
        }
    }
}

