/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import de.bluecolored.bluemap.core.util.CopyingPathVisitor;
import de.bluecolored.bluemap.core.util.stream.OnCloseOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;

public class FileHelper {
    public static OutputStream createFilepartOutputStream(Path file) throws IOException {
        Path folder = file.toAbsolutePath().normalize().getParent();
        Path partFile = folder.resolve(String.valueOf(file.getFileName()) + ".filepart");
        FileHelper.createDirectories(folder, new FileAttribute[0]);
        OutputStream os = Files.newOutputStream(partFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        return new OnCloseOutputStream(os, () -> {
            if (!Files.exists(partFile, new LinkOption[0])) {
                return;
            }
            FileHelper.createDirectories(folder, new FileAttribute[0]);
            FileHelper.atomicMove(partFile, file);
        });
    }

    public static void atomicMove(Path from, Path to) throws IOException {
        try {
            Files.move(from, to, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (IOException ex) {
            try {
                Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
            }
            catch (Throwable t2) {
                t2.addSuppressed(ex);
                throw t2;
            }
        }
    }

    public static Path createDirectories(Path dir, FileAttribute<?> ... attrs) throws IOException {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            return dir;
        }
        return Files.createDirectories(dir, attrs);
    }

    public static void extractZipFile(URL zipFile, Path targetDirectory, CopyOption ... options) throws IOException {
        Path temp = Files.createTempFile(null, ".zip", new FileAttribute[0]);
        FileHelper.copy(zipFile, temp);
        FileHelper.extractZipFile(temp, targetDirectory, options);
        Files.deleteIfExists(temp);
    }

    public static void extractZipFile(Path zipFile, Path targetDirectory, CopyOption ... options) throws IOException {
        try (FileSystem webappZipFs = FileSystems.newFileSystem(zipFile, (ClassLoader)null);){
            CopyingPathVisitor copyAction = new CopyingPathVisitor(targetDirectory, options);
            for (Path root : webappZipFs.getRootDirectories()) {
                Files.walkFileTree(root, copyAction);
            }
        }
    }

    public static void copy(URL source, Path target) throws IOException {
        try (InputStream in = source.openStream();
             OutputStream out = Files.newOutputStream(target, new OpenOption[0]);){
            in.transferTo(out);
        }
    }

    public static boolean awaitExistence(Path path, long timeout, TimeUnit unit) throws IOException, InterruptedException {
        if (Files.exists(path, new LinkOption[0])) {
            return true;
        }
        long endTime = System.currentTimeMillis() + unit.toMillis(timeout);
        Path parent = path.toAbsolutePath().normalize().getParent();
        if (parent == null) {
            throw new IOException("No parent directory exists that can be watched.");
        }
        if (!FileHelper.awaitExistence(parent, timeout, unit)) {
            return false;
        }
        try (WatchService watchService = parent.getFileSystem().newWatchService();){
            parent.register(watchService, StandardWatchEventKinds.ENTRY_CREATE);
            while (!Files.exists(path, new LinkOption[0])) {
                long now = System.currentTimeMillis();
                if (now >= endTime) {
                    boolean bl = false;
                    return bl;
                }
                WatchKey key = watchService.poll(endTime - now, TimeUnit.MILLISECONDS);
                if (key == null) continue;
                key.reset();
            }
            boolean bl = true;
            return bl;
        }
    }
}

