/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources;

import com.flowpowered.math.GenericMath;
import com.google.gson.stream.JsonReader;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.biome.Biome;
import de.bluecolored.bluemap.core.world.block.BlockAccess;
import de.bluecolored.bluemap.core.world.block.BlockNeighborhood;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class BlockColorCalculatorFactory {
    private static final int BLEND_RADIUS_H = 2;
    private static final int BLEND_RADIUS_V = 1;
    private static final int BLEND_MIN_X = -2;
    private static final int BLEND_MAX_X = 2;
    private static final int BLEND_MIN_Y = -1;
    private static final int BLEND_MAX_Y = 1;
    private static final int BLEND_MIN_Z = -2;
    private static final int BLEND_MAX_Z = 2;
    private int[] foliageMap = new int[0];
    private int[] dryFoliageMap = new int[0];
    private int[] grassMap = new int[0];
    private final Map<String, ColorFunction> blockColorMap = new HashMap<String, ColorFunction>();

    public void load(Path configFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(configFile);){
            JsonReader json = new JsonReader((Reader)reader);
            json.setLenient(true);
            json.beginObject();
            while (json.hasNext()) {
                String value;
                String key = json.nextName();
                this.blockColorMap.putIfAbsent(key, switch (value = json.nextString()) {
                    case "@foliage" -> BlockColorCalculator::getBlendedFoliageColor;
                    case "@dry_foliage" -> BlockColorCalculator::getBlendedDryFoliageColor;
                    case "@grass" -> BlockColorCalculator::getBlendedGrassColor;
                    case "@water" -> BlockColorCalculator::getBlendedWaterColor;
                    case "@redstone" -> BlockColorCalculator::getRedstoneColor;
                    default -> {
                        Color color = new Color();
                        color.parse(value).premultiplied();
                        yield (calculator, block, target) -> target.set(color);
                    }
                });
            }
            json.endObject();
        }
    }

    public void setFoliageMap(BufferedImage map) {
        this.foliageMap = new int[65536];
        map.getRGB(0, 0, 256, 256, this.foliageMap, 0, 256);
    }

    public void setDryFoliageMap(BufferedImage map) {
        this.dryFoliageMap = new int[65536];
        map.getRGB(0, 0, 256, 256, this.dryFoliageMap, 0, 256);
    }

    public void setGrassMap(BufferedImage map) {
        this.grassMap = new int[65536];
        map.getRGB(0, 0, 256, 256, this.grassMap, 0, 256);
    }

    public BlockColorCalculator createCalculator() {
        return new BlockColorCalculator();
    }

    @FunctionalInterface
    private static interface ColorFunction {
        public Color invoke(BlockColorCalculator var1, BlockNeighborhood var2, Color var3);
    }

    public class BlockColorCalculator {
        private final Color tempColor = new Color();

        public Color getBlockColor(BlockNeighborhood block, Color target) {
            String blockId = block.getBlockState().getFormatted();
            ColorFunction colorFunction = BlockColorCalculatorFactory.this.blockColorMap.get(blockId);
            if (colorFunction == null) {
                colorFunction = BlockColorCalculatorFactory.this.blockColorMap.get("default");
            }
            if (colorFunction == null) {
                colorFunction = BlockColorCalculator::getBlendedFoliageColor;
            }
            return colorFunction.invoke(this, block, target);
        }

        public Color getRedstoneColor(BlockAccess block, Color target) {
            int power = block.getBlockState().getRedstonePower();
            return target.set(((float)power + 5.0f) / 20.0f, 0.0f, 0.0f, 1.0f, true);
        }

        public Color getBlendedWaterColor(BlockNeighborhood block, Color target) {
            target.set(0.0f, 0.0f, 0.0f, 0.0f, true);
            for (int y = -1; y <= 1; ++y) {
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        Biome biome = block.getNeighborBlock(x, y, z).getBiome();
                        target.add(biome.getWaterColor());
                    }
                }
            }
            return target.flatten();
        }

        public Color getBlendedFoliageColor(BlockNeighborhood block, Color target) {
            target.set(0.0f, 0.0f, 0.0f, 0.0f, true);
            for (int y = -1; y <= 1; ++y) {
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        Biome biome = block.getNeighborBlock(x, y, z).getBiome();
                        target.add(this.getFoliageColor(biome, this.tempColor));
                    }
                }
            }
            return target.flatten();
        }

        public Color getFoliageColor(Biome biome, Color target) {
            this.getColorFromMap(biome, BlockColorCalculatorFactory.this.foliageMap, 4764952, target);
            return target.overlay(biome.getOverlayFoliageColor());
        }

        public Color getBlendedDryFoliageColor(BlockNeighborhood block, Color target) {
            target.set(0.0f, 0.0f, 0.0f, 0.0f, true);
            for (int y = -1; y <= 1; ++y) {
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        Biome biome = block.getNeighborBlock(x, y, z).getBiome();
                        target.add(this.getDryFoliageColor(biome, this.tempColor));
                    }
                }
            }
            return target.flatten();
        }

        public Color getDryFoliageColor(Biome biome, Color target) {
            this.getColorFromMap(biome, BlockColorCalculatorFactory.this.dryFoliageMap, -7381197, target);
            return target.overlay(biome.getOverlayFoliageColor());
        }

        public Color getBlendedGrassColor(BlockNeighborhood block, Color target) {
            target.set(0.0f, 0.0f, 0.0f, 0.0f, true);
            for (int y = -1; y <= 1; ++y) {
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        target.add(this.getGrassColor(block.getNeighborBlock(x, y, z), this.tempColor));
                    }
                }
            }
            return target.flatten();
        }

        public Color getGrassColor(BlockAccess block, Color target) {
            Biome biome = block.getBiome();
            this.getColorFromMap(biome, BlockColorCalculatorFactory.this.grassMap, -11365073, target);
            target.overlay(biome.getOverlayGrassColor());
            biome.getGrassColorModifier().apply(block, target);
            return target;
        }

        private void getColorFromMap(Biome biome, int[] colorMap, int defaultColor, Color target) {
            double temperature = GenericMath.clamp((double)biome.getTemperature(), (double)0.0, (double)1.0);
            double downfall = GenericMath.clamp((double)biome.getDownfall(), (double)0.0, (double)1.0);
            int y = (int)((1.0 - (downfall *= temperature)) * 255.0);
            int x = (int)((1.0 - temperature) * 255.0);
            int index = y << 8 | x;
            int color = (index >= colorMap.length ? defaultColor : colorMap[index]) | 0xFF000000;
            target.set(color);
        }
    }
}

