/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.rendermanager;

import de.bluecolored.bluemap.common.debug.DebugDump;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.core.storage.MapStorage;
import java.util.Objects;

public class StorageDeleteTask
implements RenderTask {
    private final MapStorage storage;
    private final String mapId;
    private volatile double progress;
    private volatile boolean hasMoreWork;
    private volatile boolean cancelled;

    public StorageDeleteTask(MapStorage storage, String mapId) {
        this.storage = Objects.requireNonNull(storage);
        this.mapId = Objects.requireNonNull(mapId);
        this.progress = 0.0;
        this.hasMoreWork = true;
        this.cancelled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() throws Exception {
        StorageDeleteTask storageDeleteTask = this;
        synchronized (storageDeleteTask) {
            if (!this.hasMoreWork) {
                return;
            }
            this.hasMoreWork = false;
        }
        if (this.cancelled) {
            return;
        }
        this.storage.delete(progress -> {
            this.progress = progress;
            return !this.cancelled;
        });
    }

    @Override
    public boolean hasMoreWork() {
        return this.hasMoreWork && !this.cancelled;
    }

    @Override
    @DebugDump
    public double estimateProgress() {
        return this.progress;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public boolean contains(RenderTask task) {
        if (task == this) {
            return true;
        }
        if (task instanceof StorageDeleteTask) {
            StorageDeleteTask sTask = (StorageDeleteTask)task;
            return this.storage.equals(sTask.storage) && this.mapId.equals(sTask.mapId);
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "deleting map '%s'".formatted(this.mapId);
    }
}

