/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config;

public class ConfigurationException
extends Exception {
    private static final String FORMATTING_BAR = "################################";
    private final String explanation;

    public ConfigurationException(String explanation) {
        this.explanation = explanation;
    }

    public ConfigurationException(String message, String explanation) {
        super(message);
        this.explanation = explanation;
    }

    public ConfigurationException(String explanation, Throwable cause) {
        super(cause);
        this.explanation = explanation;
    }

    public ConfigurationException(String message, String explanation, Throwable cause) {
        super(message, cause);
        this.explanation = explanation;
    }

    public Throwable getRootCause() {
        Throwable cause = this.getCause();
        if (cause instanceof ConfigurationException) {
            return ((ConfigurationException)cause).getRootCause();
        }
        return cause;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getFullExplanation() {
        Throwable cause = this.getCause();
        if (cause instanceof ConfigurationException) {
            return this.getExplanation() + "\n\n" + ((ConfigurationException)cause).getFullExplanation();
        }
        return this.getExplanation();
    }

    public String getFormattedExplanation() {
        String indentedExplanation = " " + this.getFullExplanation().replace("\n", "\n ");
        return "\n################################\n There is a problem with your BlueMap setup!\n" + indentedExplanation + "\n################################";
    }
}

