/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.addons;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.bluecolored.bluemap.common.addons.AddonInfo;
import de.bluecolored.bluemap.common.addons.LoadedAddon;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class Addons {
    private static final String PLUGIN_YML = "plugin.yml";
    private static final String MODS_TOML = "META-INF/mods.toml";
    private static final String FABRIC_MOD_JSON = "fabric.mod.json";
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<String, LoadedAddon> LOADED_ADDONS = new ConcurrentHashMap<String, LoadedAddon>();

    private Addons() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void tryLoadAddons(Path root) {
        Addons.tryLoadAddons(root, false);
    }

    public static void tryLoadAddons(Path root, boolean expectOnlyAddons) {
        if (!Files.exists(root, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.list(root);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.getFileName().toString().endsWith(".jar")).forEach(expectOnlyAddons ? Addons::tryLoadAddon : Addons::tryLoadJar);
        }
        catch (IOException e) {
            Logger.global.logError("Failed to load addons from '%s'".formatted(root), e);
        }
    }

    public static void tryLoadAddon(Path addonJarFile) {
        try {
            AddonInfo addonInfo = Addons.loadAddonInfo(addonJarFile);
            if (addonInfo == null) {
                throw Addons.createRichExceptionForFile(addonJarFile);
            }
            if (LOADED_ADDONS.containsKey(addonInfo.getId())) {
                return;
            }
            Addons.loadAddon(addonJarFile, addonInfo);
        }
        catch (ConfigurationException e) {
            ConfigurationException e2 = new ConfigurationException("BlueMap failed to load the addon '%s'!".formatted(addonJarFile), e);
            Logger.global.logWarning(e2.getFormattedExplanation());
            Logger.global.logError(e2);
        }
    }

    public static void tryLoadJar(Path addonJarFile) {
        try {
            AddonInfo addonInfo = Addons.loadAddonInfo(addonJarFile);
            if (addonInfo == null) {
                Logger.global.logDebug("No %s found in '%s', skipping...".formatted("bluemap.addon.json", addonJarFile));
                return;
            }
            if (LOADED_ADDONS.containsKey(addonInfo.getId())) {
                return;
            }
            Addons.loadAddon(addonJarFile, addonInfo);
        }
        catch (ConfigurationException e) {
            ConfigurationException e2 = new ConfigurationException("BlueMap failed to load the addon '%s'!".formatted(addonJarFile), e);
            Logger.global.logWarning(e2.getFormattedExplanation());
            Logger.global.logError(e2);
        }
    }

    public static synchronized void loadAddon(Path jarFile, AddonInfo addonInfo) throws ConfigurationException {
        Logger.global.logInfo("Loading BlueMap Addon: %s (%s)".formatted(addonInfo.getId(), jarFile));
        if (LOADED_ADDONS.containsKey(addonInfo.getId())) {
            throw new ConfigurationException("There is already an addon with same id ('%s') loaded!".formatted(addonInfo.getId()));
        }
        try {
            Class<?> entrypointClass;
            ClassLoader addonClassLoader = BlueMap.class.getClassLoader();
            try {
                entrypointClass = addonClassLoader.loadClass(addonInfo.getEntrypoint());
            }
            catch (ClassNotFoundException e) {
                addonClassLoader = new URLClassLoader(new URL[]{jarFile.toUri().toURL()}, BlueMap.class.getClassLoader());
                entrypointClass = addonClassLoader.loadClass(addonInfo.getEntrypoint());
            }
            Object instance = entrypointClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            LoadedAddon addon = new LoadedAddon(addonInfo, addonClassLoader, instance);
            LOADED_ADDONS.put(addonInfo.getId(), addon);
            if (instance instanceof Runnable) {
                Runnable runnable = (Runnable)instance;
                runnable.run();
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("There was an exception trying to initialize the addon!", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static AddonInfo loadAddonInfo(Path addonJarFile) throws ConfigurationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ConfigurationException createRichExceptionForFile(Path jarFile) {
        boolean isPlugin = false;
        boolean isMod = false;
        try (FileSystem fileSystem = FileSystems.newFileSystem(jarFile, (ClassLoader)null);){
            for (Path root : fileSystem.getRootDirectories()) {
                if (Files.exists(root.resolve(PLUGIN_YML), new LinkOption[0])) {
                    isPlugin = true;
                }
                if (Files.exists(root.resolve(MODS_TOML), new LinkOption[0])) {
                    isMod = true;
                }
                if (!Files.exists(root.resolve(FABRIC_MOD_JSON), new LinkOption[0])) continue;
                isMod = true;
            }
        }
        catch (IOException e) {
            Logger.global.logError("Failed to log file-info for '%s'".formatted(jarFile), e);
        }
        if (!isPlugin && !isMod) {
            return new ConfigurationException("File '%s' does not seem to be a valid native bluemap addon.\n".strip().formatted(jarFile));
        }
        String type = isPlugin ? "plugin" : "mod";
        String targetFolder = isPlugin ? "./plugins" : "./mods";
        return new ConfigurationException("File '%s' seems to be a %s and not a native bluemap addon.\nTry adding it to the '%s' folder of your server instead!\n".strip().formatted(jarFile, type, targetFolder));
    }
}

