/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class ContentTypeRegistry {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final Map<String, String> SUFFIX_MAP = new HashMap<String, String>();

    public static String fromPath(Path path) {
        return ContentTypeRegistry.fromFileName(path.getFileName().toString());
    }

    public static String fromFileName(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i < 0) {
            return DEFAULT_CONTENT_TYPE;
        }
        int s2 = fileName.lastIndexOf(47);
        if (i < s2) {
            return DEFAULT_CONTENT_TYPE;
        }
        String suffix = fileName.substring(i + 1);
        return ContentTypeRegistry.fromFileSuffix(suffix);
    }

    public static String fromFileSuffix(String suffix) {
        String contentType = SUFFIX_MAP.get(suffix);
        if (contentType != null) {
            return contentType;
        }
        return DEFAULT_CONTENT_TYPE;
    }

    public static void register(String fileSuffix, String contentType) {
        SUFFIX_MAP.put(fileSuffix, contentType);
    }

    static {
        ContentTypeRegistry.register("txt", "text/plain");
        ContentTypeRegistry.register("css", "text/css");
        ContentTypeRegistry.register("csv", "text/csv");
        ContentTypeRegistry.register("htm", "text/html");
        ContentTypeRegistry.register("html", "text/html");
        ContentTypeRegistry.register("js", "text/javascript");
        ContentTypeRegistry.register("xml", "text/xml");
        ContentTypeRegistry.register("png", "image/png");
        ContentTypeRegistry.register("jpg", "image/jpeg");
        ContentTypeRegistry.register("jpeg", "image/jpeg");
        ContentTypeRegistry.register("gif", "image/gif");
        ContentTypeRegistry.register("webp", "image/webp");
        ContentTypeRegistry.register("tif", "image/tiff");
        ContentTypeRegistry.register("tiff", "image/tiff");
        ContentTypeRegistry.register("svg", "image/svg+xml");
        ContentTypeRegistry.register("json", "application/json");
        ContentTypeRegistry.register("mp3", "audio/mpeg");
        ContentTypeRegistry.register("oga", "audio/ogg");
        ContentTypeRegistry.register("wav", "audio/wav");
        ContentTypeRegistry.register("weba", "audio/webm");
        ContentTypeRegistry.register("mp4", "video/mp4");
        ContentTypeRegistry.register("mpeg", "video/mpeg");
        ContentTypeRegistry.register("webm", "video/webm");
        ContentTypeRegistry.register("ttf", "font/ttf");
        ContentTypeRegistry.register("woff", "font/woff");
        ContentTypeRegistry.register("woff2", "font/woff2");
    }
}

